/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.oss.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ExecutionContext;
import com.aliyun.common.comm.RequestMessage;
import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.oss.OSSException;
import com.aliyun.openservices.oss.internal.OSSOperation;
import com.aliyun.openservices.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.openservices.oss.internal.OSSUtils;
import com.aliyun.openservices.oss.internal.ResponseParser;
import com.aliyun.openservices.oss.model.AccessControlList;
import com.aliyun.openservices.oss.model.Bucket;
import com.aliyun.openservices.oss.model.BucketLoggingResult;
import com.aliyun.openservices.oss.model.BucketWebsiteResult;
import com.aliyun.openservices.oss.model.CannedAccessControlList;
import com.aliyun.openservices.oss.model.CreateBucketRequest;
import com.aliyun.openservices.oss.model.ListObjectsRequest;
import com.aliyun.openservices.oss.model.ObjectListing;
import com.aliyun.openservices.oss.model.SetBucketLoggingRequest;
import com.aliyun.openservices.oss.model.SetBucketWebsiteRequest;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class OSSBucketOperation
extends OSSOperation {
    private static final String SUBRESOURCE_ACL = "acl";
    private static final String SUBRESOURCE_LOCATION = "location";
    private static final String SUBRESOURCE_LOGGING = "logging";
    private static final String SUBRESOURCE_WEBSITE = "website";

    public OSSBucketOperation(URI endpoint, ServiceClient client, ServiceCredentials cred) {
        super(endpoint, client, cred);
    }

    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws OSSException, ClientException {
        String bucketName = createBucketRequest.getBucketName();
        String locationConstraint = createBucketRequest.getLocationConstraint();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        String xmlBody = "";
        if (locationConstraint != null) {
            xmlBody = OSSBucketOperation.buildCreateBucketXml(locationConstraint);
        }
        byte[] inputBytes = xmlBody.getBytes();
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setInputStream(new ByteArrayInputStream(inputBytes)).setInputSize(inputBytes.length).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
        return new Bucket(bucketName);
    }

    public void deleteBucket(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Bucket> listBuckets() throws OSSException, ClientException {
        List<Bucket> list;
        block3: {
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod());
                response = this.send(request, context, true);
                list = ResponseParser.parseListBucket(response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return list;
    }

    public void setBucketAcl(String bucketName, CannedAccessControlList acl) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        if (acl == null) {
            acl = CannedAccessControlList.Private;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-oss-acl", acl.toString());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_ACL, null);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setHeaders(headers).setParameters(params).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlList getBucketAcl(String bucketName) throws OSSException, ClientException {
        AccessControlList accessControlList;
        block3: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SUBRESOURCE_ACL, null);
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
                response = this.send(request, context, true);
                accessControlList = ResponseParser.parseGetBucketAcl(response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return accessControlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBucketLocation(String bucketName) {
        String string;
        block3: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SUBRESOURCE_LOCATION, null);
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
                response = this.send(request, context, true);
                string = ResponseParser.parseGetBucketLocation(response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return string;
    }

    public boolean bucketExists(String bucketName) throws OSSException, ClientException {
        block2: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            try {
                this.getBucketAcl(bucketName);
            }
            catch (OSSException e) {
                if (!e.getErrorCode().equals("NoSuchBucket")) break block2;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectListing listObjects(ListObjectsRequest listObjectRequest) throws OSSException, ClientException {
        ObjectListing objectListing;
        block8: {
            CodingUtils.assertParameterNotNull(listObjectRequest, "request");
            if (listObjectRequest.getBucketName() == null) {
                throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MustSetBucketName"));
            }
            OSSUtils.ensureBucketNameValid(listObjectRequest.getBucketName());
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            if (listObjectRequest.getPrefix() != null) {
                params.put("prefix", listObjectRequest.getPrefix());
            }
            if (listObjectRequest.getMarker() != null) {
                params.put("marker", listObjectRequest.getMarker());
            }
            if (listObjectRequest.getDelimiter() != null) {
                params.put("delimiter", listObjectRequest.getDelimiter());
            }
            if (listObjectRequest.getMaxKeys() != null) {
                params.put("max-keys", Integer.toString(listObjectRequest.getMaxKeys()));
            }
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(listObjectRequest.getBucketName()).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), listObjectRequest.getBucketName());
                response = this.send(request, context, true);
                objectListing = ResponseParser.parseListObjects(response.getContent());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return objectListing;
    }

    public void setBucketLogging(SetBucketLoggingRequest setBucketLoggingRequest) throws OSSException, ClientException {
        String bucketName = setBucketLoggingRequest.getBucketName();
        String targetBucket = setBucketLoggingRequest.getTargetBucket();
        String targetPrefix = setBucketLoggingRequest.getTargetPrefix();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(targetBucket, "targetBucket");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_LOGGING, null);
        String xmlBody = "";
        xmlBody = OSSBucketOperation.buildPutBucketLoggingXml(targetBucket, targetPrefix);
        byte[] inputBytes = xmlBody.getBytes();
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStream(new ByteArrayInputStream(inputBytes)).setInputSize(inputBytes.length).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketLoggingResult getBucketLogging(String bucketName) throws OSSException, ClientException {
        BucketLoggingResult bucketLoggingResult;
        block3: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SUBRESOURCE_LOGGING, null);
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
                response = this.send(request, context, true);
                bucketLoggingResult = ResponseParser.parseBucketLogging(response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return bucketLoggingResult;
    }

    public void deleteBucketLogging(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_LOGGING, null);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    public void setBucketWebsite(SetBucketWebsiteRequest setBucketWebSiteRequest) throws OSSException, ClientException {
        String bucketName = setBucketWebSiteRequest.getBucketName();
        String indexDocument = setBucketWebSiteRequest.getIndexDocument();
        String errorDocument = setBucketWebSiteRequest.getErrorDocument();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(indexDocument, "indexDocument");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_WEBSITE, null);
        String xmlBody = "";
        xmlBody = OSSBucketOperation.buildPutBucketWebSiteXml(indexDocument, errorDocument);
        byte[] inputBytes = xmlBody.getBytes();
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStream(new ByteArrayInputStream(inputBytes)).setInputSize(inputBytes.length).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketWebsiteResult getBucketWebsite(String bucketName) throws OSSException, ClientException {
        BucketWebsiteResult bucketWebsiteResult;
        block3: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SUBRESOURCE_WEBSITE, null);
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
                response = this.send(request, context, true);
                bucketWebsiteResult = ResponseParser.parseBucketWebsite(response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return bucketWebsiteResult;
    }

    public void deleteBucketWebsite(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_WEBSITE, null);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    private static String buildPutBucketWebSiteXml(String indexDocument, String errorDocument) {
        StringBuffer xml = new StringBuffer();
        xml.append("<WebsiteConfiguration>");
        xml.append("<IndexDocument>");
        xml.append("<Suffix>" + indexDocument + "</Suffix>");
        xml.append("</IndexDocument>");
        if (errorDocument != null) {
            xml.append("<ErrorDocument>");
            xml.append("<Key>" + errorDocument + "</Key>");
            xml.append("</ErrorDocument>");
        }
        xml.append("</WebsiteConfiguration>");
        return xml.toString();
    }

    private static String buildPutBucketLoggingXml(String targetBucket, String targetPrefix) {
        StringBuffer xml = new StringBuffer();
        xml.append("<BucketLoggingStatus>");
        xml.append("<LoggingEnabled>");
        xml.append("<TargetBucket>" + targetBucket + "</TargetBucket>");
        if (targetPrefix != null) {
            xml.append("<TargetPrefix>" + targetPrefix + "</TargetPrefix>");
        }
        xml.append("</LoggingEnabled>");
        xml.append("</BucketLoggingStatus>");
        return xml.toString();
    }

    private static String buildCreateBucketXml(String locationConstraint) {
        StringBuffer xml = new StringBuffer();
        xml.append("<CreateBucketConfiguration>");
        xml.append("<LocationConstraint>" + locationConstraint + "</LocationConstraint>");
        xml.append("</CreateBucketConfiguration>");
        return xml.toString();
    }
}

