/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.metadata;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.tensorflow.lite.support.metadata.Preconditions;
import org.tensorflow.lite.support.metadata.schema.ModelMetadata;
import org.tensorflow.lite.support.metadata.schema.SubGraphMetadata;
import org.tensorflow.lite.support.metadata.schema.TensorMetadata;

final class ModelMetadataInfo {
    private final ModelMetadata modelMetadata;
    private final List<TensorMetadata> inputsMetadata;
    private final List<TensorMetadata> outputsMetadata;
    private final String minVersion;

    ModelMetadataInfo(ByteBuffer buffer) {
        ModelMetadataInfo.assertTFLiteMetadata(buffer);
        this.modelMetadata = ModelMetadata.getRootAsModelMetadata(buffer);
        Preconditions.checkArgument(this.modelMetadata.subgraphMetadataLength() > 0, "The metadata flatbuffer does not contain any subgraph metadata.");
        this.inputsMetadata = ModelMetadataInfo.getInputsMetadata(this.modelMetadata);
        this.outputsMetadata = ModelMetadataInfo.getOutputsMetadata(this.modelMetadata);
        this.minVersion = this.modelMetadata.minParserVersion();
    }

    int getInputTensorCount() {
        return this.inputsMetadata.size();
    }

    @Nullable
    TensorMetadata getInputTensorMetadata(int inputIndex) {
        Preconditions.checkArgument(inputIndex >= 0 && inputIndex < this.inputsMetadata.size(), "The inputIndex specified is invalid.");
        return this.inputsMetadata.get(inputIndex);
    }

    @Nullable
    String getMininumParserVersion() {
        return this.minVersion;
    }

    ModelMetadata getModelMetadata() {
        return this.modelMetadata;
    }

    int getOutputTensorCount() {
        return this.outputsMetadata.size();
    }

    @Nullable
    TensorMetadata getOutputTensorMetadata(int outputIndex) {
        Preconditions.checkArgument(outputIndex >= 0 && outputIndex < this.outputsMetadata.size(), "The outputIndex specified is invalid.");
        return this.outputsMetadata.get(outputIndex);
    }

    private static void assertTFLiteMetadata(ByteBuffer buffer) {
        Preconditions.checkNotNull(buffer, "Metadata flatbuffer cannot be null.");
        Preconditions.checkArgument(ModelMetadata.ModelMetadataBufferHasIdentifier(buffer), "The identifier of the metadata is invalid. The buffer may not be a valid TFLite metadata flatbuffer.");
    }

    private static List<TensorMetadata> getInputsMetadata(ModelMetadata modelMetadata) {
        SubGraphMetadata subgraphMetadata = modelMetadata.subgraphMetadata(0);
        int tensorNum = subgraphMetadata.inputTensorMetadataLength();
        ArrayList<TensorMetadata> inputsMetadata = new ArrayList<TensorMetadata>(tensorNum);
        for (int i = 0; i < tensorNum; ++i) {
            inputsMetadata.add(subgraphMetadata.inputTensorMetadata(i));
        }
        return Collections.unmodifiableList(inputsMetadata);
    }

    private static List<TensorMetadata> getOutputsMetadata(ModelMetadata modelMetadata) {
        SubGraphMetadata subgraphMetadata = modelMetadata.subgraphMetadata(0);
        int tensorNum = subgraphMetadata.outputTensorMetadataLength();
        ArrayList<TensorMetadata> outputsMetadata = new ArrayList<TensorMetadata>(tensorNum);
        for (int i = 0; i < tensorNum; ++i) {
            outputsMetadata.add(subgraphMetadata.outputTensorMetadata(i));
        }
        return Collections.unmodifiableList(outputsMetadata);
    }
}

