/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.loadbalancer;

import feign.Client;
import feign.httpclient.ApacheHttpClient;
import org.apache.http.client.HttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.HttpClient5DisabledConditions;
import org.springframework.cloud.openfeign.clientconfig.HttpClientFeignConfiguration;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.OnRetryNotEnabledCondition;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ApacheHttpClient.class})
@ConditionalOnBean(value={LoadBalancerClient.class, LoadBalancerClientFactory.class})
@ConditionalOnProperty(value={"feign.httpclient.enabled"}, matchIfMissing=true)
@Conditional(value={HttpClient5DisabledConditions.class})
@Import(value={HttpClientFeignConfiguration.class})
@EnableConfigurationProperties(value={LoadBalancerProperties.class})
class HttpClientFeignLoadBalancerConfiguration {
    HttpClientFeignLoadBalancerConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={OnRetryNotEnabledCondition.class})
    public Client feignClient(LoadBalancerClient loadBalancerClient, HttpClient httpClient, LoadBalancerProperties properties, LoadBalancerClientFactory loadBalancerClientFactory) {
        ApacheHttpClient delegate = new ApacheHttpClient(httpClient);
        return new FeignBlockingLoadBalancerClient((Client)delegate, loadBalancerClient, properties, loadBalancerClientFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.retry.support.RetryTemplate"})
    @ConditionalOnBean(value={LoadBalancedRetryFactory.class})
    @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, havingValue="true", matchIfMissing=true)
    public Client feignRetryClient(LoadBalancerClient loadBalancerClient, HttpClient httpClient, LoadBalancedRetryFactory loadBalancedRetryFactory, LoadBalancerProperties properties, LoadBalancerClientFactory loadBalancerClientFactory) {
        ApacheHttpClient delegate = new ApacheHttpClient(httpClient);
        return new RetryableFeignBlockingLoadBalancerClient((Client)delegate, loadBalancerClient, loadBalancedRetryFactory, properties, loadBalancerClientFactory);
    }
}

