/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SecureHeadersProperties;
import org.springframework.http.HttpHeaders;

public class SecureHeadersGatewayFilterFactory
extends AbstractGatewayFilterFactory {
    public static final String X_XSS_PROTECTION_HEADER = "X-Xss-Protection";
    public static final String STRICT_TRANSPORT_SECURITY_HEADER = "Strict-Transport-Security";
    public static final String X_FRAME_OPTIONS_HEADER = "X-Frame-Options";
    public static final String X_CONTENT_TYPE_OPTIONS_HEADER = "X-Content-Type-Options";
    public static final String REFERRER_POLICY_HEADER = "Referrer-Policy";
    public static final String CONTENT_SECURITY_POLICY_HEADER = "Content-Security-Policy";
    public static final String X_DOWNLOAD_OPTIONS_HEADER = "X-Download-Options";
    public static final String X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER = "X-Permitted-Cross-Domain-Policies";
    private final SecureHeadersProperties properties;

    public SecureHeadersGatewayFilterFactory(SecureHeadersProperties properties) {
        this.properties = properties;
    }

    @Override
    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            HttpHeaders headers = exchange.getResponse().getHeaders();
            List<String> disabled = this.properties.getDisable();
            if (this.isEnabled(disabled, X_XSS_PROTECTION_HEADER)) {
                headers.add(X_XSS_PROTECTION_HEADER, this.properties.getXssProtectionHeader());
            }
            if (this.isEnabled(disabled, STRICT_TRANSPORT_SECURITY_HEADER)) {
                headers.add(STRICT_TRANSPORT_SECURITY_HEADER, this.properties.getStrictTransportSecurity());
            }
            if (this.isEnabled(disabled, X_FRAME_OPTIONS_HEADER)) {
                headers.add(X_FRAME_OPTIONS_HEADER, this.properties.getFrameOptions());
            }
            if (this.isEnabled(disabled, X_CONTENT_TYPE_OPTIONS_HEADER)) {
                headers.add(X_CONTENT_TYPE_OPTIONS_HEADER, this.properties.getContentTypeOptions());
            }
            if (this.isEnabled(disabled, REFERRER_POLICY_HEADER)) {
                headers.add(REFERRER_POLICY_HEADER, this.properties.getReferrerPolicy());
            }
            if (this.isEnabled(disabled, CONTENT_SECURITY_POLICY_HEADER)) {
                headers.add(CONTENT_SECURITY_POLICY_HEADER, this.properties.getContentSecurityPolicy());
            }
            if (this.isEnabled(disabled, X_DOWNLOAD_OPTIONS_HEADER)) {
                headers.add(X_DOWNLOAD_OPTIONS_HEADER, this.properties.getDownloadOptions());
            }
            if (this.isEnabled(disabled, X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER)) {
                headers.add(X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER, this.properties.getPermittedCrossDomainPolicies());
            }
            return chain.filter(exchange);
        };
    }

    private boolean isEnabled(List<String> disabledHeaders, String header) {
        return !disabledHeaders.contains(header.toLowerCase());
    }
}

