/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncSemaphore {
    private final AtomicInteger counter;
    private final Queue<CompletableFuture<Void>> listeners = new ConcurrentLinkedQueue<CompletableFuture<Void>>();

    public AsyncSemaphore(int permits) {
        this.counter = new AtomicInteger(permits);
    }

    public boolean tryAcquire(long timeoutMillis) {
        CompletableFuture<Void> f = this.acquire();
        try {
            f.get(timeoutMillis, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public int queueSize() {
        return this.listeners.size();
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public CompletableFuture<Void> acquire() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.listeners.add(future);
        this.tryRun();
        return future;
    }

    public void acquire(Runnable listener) {
        this.acquire().thenAccept(r -> listener.run());
    }

    private void tryRun() {
        do {
            if (this.counter.decrementAndGet() < 0) continue;
            CompletableFuture<Void> future = this.listeners.poll();
            if (future == null) {
                this.counter.incrementAndGet();
                return;
            }
            if (!future.complete(null)) continue;
            return;
        } while (this.counter.incrementAndGet() > 0);
    }

    public int getCounter() {
        return this.counter.get();
    }

    public void release() {
        this.counter.incrementAndGet();
        this.tryRun();
    }

    public String toString() {
        return "value:" + this.counter + ":queue:" + this.queueSize();
    }
}

