/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.cache.LRUCacheMap;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.CustomObjectInputStream;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.executor.CronExpression;
import org.redisson.executor.RedissonClassLoader;
import org.redisson.executor.RemoteExecutorService;
import org.redisson.executor.RemoteExecutorServiceAsync;
import org.redisson.executor.ScheduledTasksService;
import org.redisson.executor.params.ScheduledAtFixedRateParameters;
import org.redisson.executor.params.ScheduledCronExpressionParameters;
import org.redisson.executor.params.ScheduledParameters;
import org.redisson.executor.params.ScheduledWithFixedDelayParameters;
import org.redisson.executor.params.TaskParameters;
import org.redisson.misc.Hash;
import org.redisson.misc.HashValue;
import org.redisson.misc.Injector;
import org.redisson.remote.RequestId;
import org.redisson.remote.ResponseEntry;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;

public class TasksRunnerService
implements RemoteExecutorService {
    private static final Map<HashValue, Codec> CODECS = new LRUCacheMap<HashValue, Codec>(500, 0L, 0L);
    private final Codec codec;
    private final String name;
    private final CommandAsyncExecutor commandExecutor;
    private final RedissonClient redisson;
    private String tasksCounterName;
    private String statusName;
    private String terminationTopicName;
    private String tasksName;
    private String schedulerQueueName;
    private String schedulerChannelName;
    private String tasksRetryIntervalName;
    private String tasksExpirationTimeName;
    private BeanFactory beanFactory;
    private ConcurrentMap<String, ResponseEntry> responses;

    public TasksRunnerService(CommandAsyncExecutor commandExecutor, RedissonClient redisson, Codec codec, String name, ConcurrentMap<String, ResponseEntry> responses) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.redisson = redisson;
        this.responses = responses;
        this.codec = codec;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setTasksExpirationTimeName(String tasksExpirationTimeName) {
        this.tasksExpirationTimeName = tasksExpirationTimeName;
    }

    public void setTasksRetryIntervalName(String tasksRetryInterval) {
        this.tasksRetryIntervalName = tasksRetryInterval;
    }

    public void setSchedulerQueueName(String schedulerQueueName) {
        this.schedulerQueueName = schedulerQueueName;
    }

    public void setSchedulerChannelName(String schedulerChannelName) {
        this.schedulerChannelName = schedulerChannelName;
    }

    public void setTasksName(String tasksName) {
        this.tasksName = tasksName;
    }

    public void setTasksCounterName(String tasksCounterName) {
        this.tasksCounterName = tasksCounterName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public void setTerminationTopicName(String terminationTopicName) {
        this.terminationTopicName = terminationTopicName;
    }

    @Override
    public void scheduleAtFixedRate(ScheduledAtFixedRateParameters params) {
        long start = System.nanoTime();
        this.executeRunnable(params, false);
        long spent = params.getSpentTime() + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        long newStartTime = System.currentTimeMillis() + Math.max(params.getPeriod() - spent, 0L);
        params.setStartTime(newStartTime);
        spent = Math.max(spent - params.getPeriod(), 0L);
        params.setSpentTime(spent);
        this.asyncScheduledServiceAtFixed(params.getExecutorId(), params.getRequestId()).scheduleAtFixedRate(params);
    }

    @Override
    public void schedule(ScheduledCronExpressionParameters params) {
        CronExpression expression = new CronExpression(params.getCronExpression());
        expression.setTimeZone(TimeZone.getTimeZone(params.getTimezone()));
        Date nextStartDate = expression.getNextValidTimeAfter(new Date());
        RFuture<Void> future = null;
        if (nextStartDate != null) {
            RemoteExecutorServiceAsync service = this.asyncScheduledServiceAtFixed(params.getExecutorId(), params.getRequestId());
            params.setStartTime(nextStartDate.getTime());
            future = service.schedule(params);
        }
        try {
            this.executeRunnable(params, nextStartDate == null);
        }
        catch (Exception e) {
            if (future != null) {
                future.cancel(true);
            }
            throw e;
        }
    }

    private RemoteExecutorServiceAsync asyncScheduledServiceAtFixed(String executorId, String requestId) {
        ScheduledTasksService scheduledRemoteService = new ScheduledTasksService(this.codec, this.name, this.commandExecutor, executorId, this.responses);
        scheduledRemoteService.setTerminationTopicName(this.terminationTopicName);
        scheduledRemoteService.setTasksCounterName(this.tasksCounterName);
        scheduledRemoteService.setStatusName(this.statusName);
        scheduledRemoteService.setSchedulerQueueName(this.schedulerQueueName);
        scheduledRemoteService.setSchedulerChannelName(this.schedulerChannelName);
        scheduledRemoteService.setTasksName(this.tasksName);
        scheduledRemoteService.setRequestId(new RequestId(requestId));
        scheduledRemoteService.setTasksExpirationTimeName(this.tasksExpirationTimeName);
        scheduledRemoteService.setTasksRetryIntervalName(this.tasksRetryIntervalName);
        RemoteExecutorServiceAsync asyncScheduledServiceAtFixed = scheduledRemoteService.get(RemoteExecutorServiceAsync.class, RemoteInvocationOptions.defaults().noAck().noResult());
        return asyncScheduledServiceAtFixed;
    }

    @Override
    public void scheduleWithFixedDelay(ScheduledWithFixedDelayParameters params) {
        this.executeRunnable(params, false);
        if (!this.redisson.getMap(this.tasksName, StringCodec.INSTANCE).containsKey(params.getRequestId())) {
            return;
        }
        long newStartTime = System.currentTimeMillis() + params.getDelay();
        params.setStartTime(newStartTime);
        this.asyncScheduledServiceAtFixed(params.getExecutorId(), params.getRequestId()).scheduleWithFixedDelay(params);
    }

    @Override
    public Object scheduleCallable(ScheduledParameters params) {
        return this.executeCallable(params);
    }

    @Override
    public void scheduleRunnable(ScheduledParameters params) {
        this.executeRunnable(params);
    }

    @Override
    public Object executeCallable(TaskParameters params) {
        Object res;
        try {
            RFuture<Long> future = this.renewRetryTime(params.getRequestId());
            future.sync();
            Callable callable = (Callable)this.decode(params);
            res = callable.call();
        }
        catch (RedissonShutdownException e) {
            throw e;
        }
        catch (RedisException e) {
            this.finish(params.getRequestId(), true);
            throw e;
        }
        catch (Exception e) {
            this.finish(params.getRequestId(), true);
            throw new IllegalArgumentException(e);
        }
        this.finish(params.getRequestId(), true);
        return res;
    }

    protected void scheduleRetryTimeRenewal(final String requestId, Long retryInterval) {
        if (retryInterval == null) {
            return;
        }
        this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                TasksRunnerService.this.renewRetryTime(requestId);
            }
        }, Math.max(1000L, retryInterval / 2L), TimeUnit.MILLISECONDS);
    }

    protected RFuture<Long> renewRetryTime(String requestId) {
        RFuture<Long> future = this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LONG, "local name = ARGV[2];local scheduledName = ARGV[2];if string.sub(scheduledName, 1, 2) ~= 'ff' then scheduledName = 'ff' .. scheduledName; else name = string.sub(name, 3, string.len(name)); end;local retryInterval = redis.call('get', KEYS[4]);if redis.call('exists', KEYS[1]) == 0 and retryInterval ~= false and redis.call('hexists', KEYS[5], name) == 1 then local startTime = tonumber(ARGV[1]) + tonumber(retryInterval);redis.call('zadd', KEYS[2], startTime, scheduledName);local v = redis.call('zrange', KEYS[2], 0, 0); if v[1] == ARGV[2] then redis.call('publish', KEYS[3], startTime); end;return retryInterval; end;return nil;", Arrays.asList(this.statusName, this.schedulerQueueName, this.schedulerChannelName, this.tasksRetryIntervalName, this.tasksName), System.currentTimeMillis(), requestId);
        future.onComplete((res, e) -> {
            if (e != null) {
                this.scheduleRetryTimeRenewal(requestId, 10000L);
                return;
            }
            if (res != null) {
                this.scheduleRetryTimeRenewal(requestId, (Long)res);
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T decode(TaskParameters params) {
        ByteBuf classBodyBuf = Unpooled.wrappedBuffer((byte[])params.getClassBody());
        ByteBuf stateBuf = Unpooled.wrappedBuffer((byte[])params.getState());
        try {
            Object task;
            HashValue hash = new HashValue(Hash.hash128(classBodyBuf));
            Codec classLoaderCodec = CODECS.get(hash);
            if (classLoaderCodec == null) {
                RedissonClassLoader cl = new RedissonClassLoader(this.codec.getClassLoader());
                cl.loadClass(params.getClassName(), params.getClassBody());
                classLoaderCodec = (Codec)this.codec.getClass().getConstructor(ClassLoader.class).newInstance(cl);
                CODECS.put(hash, classLoaderCodec);
            }
            if (params.getLambdaBody() != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(params.getLambdaBody());
                ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoaderCodec.getClassLoader());
                    CustomObjectInputStream oo = new CustomObjectInputStream(classLoaderCodec.getClassLoader(), is);
                    task = oo.readObject();
                    oo.close();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
                }
            } else {
                task = classLoaderCodec.getValueDecoder().decode(stateBuf, null);
            }
            Injector.inject(task, RedissonClient.class, this.redisson);
            Injector.inject(task, String.class, params.getRequestId());
            if (this.beanFactory != null) {
                AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
                bpp.setBeanFactory(this.beanFactory);
                bpp.processInjection(task);
            }
            Object object = task;
            return (T)object;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialize codec with ClassLoader parameter", e);
        }
        finally {
            classBodyBuf.release();
            stateBuf.release();
        }
    }

    public void executeRunnable(TaskParameters params, boolean removeTask) {
        try {
            if (params.getRequestId() != null && params.getRequestId().startsWith("00")) {
                RFuture<Long> future = this.renewRetryTime(params.getRequestId());
                try {
                    future.sync();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            Runnable runnable = (Runnable)this.decode(params);
            runnable.run();
        }
        catch (RedissonShutdownException e) {
            throw e;
        }
        catch (RedisException e) {
            this.finish(params.getRequestId(), removeTask);
            throw e;
        }
        this.finish(params.getRequestId(), removeTask);
    }

    @Override
    public void executeRunnable(TaskParameters params) {
        this.executeRunnable(params, true);
    }

    void finish(String requestId, boolean removeTask) {
        String script = "";
        if (removeTask) {
            script = script + "local scheduled = redis.call('zscore', KEYS[5], ARGV[3]);if scheduled == false then redis.call('hdel', KEYS[4], ARGV[3]); end;";
        }
        script = script + "redis.call('zrem', KEYS[5], 'ff' .. ARGV[3]);if redis.call('decr', KEYS[1]) == 0 then redis.call('del', KEYS[1]);if redis.call('get', KEYS[2]) == ARGV[1] then redis.call('del', KEYS[6]);redis.call('set', KEYS[2], ARGV[2]);redis.call('publish', KEYS[3], ARGV[2]);end;end;";
        this.commandExecutor.get(this.commandExecutor.evalWriteAsync(this.name, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_VOID, script, Arrays.asList(this.tasksCounterName, this.statusName, this.terminationTopicName, this.tasksName, this.schedulerQueueName, this.tasksRetryIntervalName), 1, 2, requestId));
    }
}

