/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RFuture;
import org.redisson.api.RIdGenerator;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonIdGenerator
extends RedissonExpirable
implements RIdGenerator {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicLong start = new AtomicLong();
    private final AtomicLong counter = new AtomicLong();
    private final Queue<RPromise<Long>> queue = new ConcurrentLinkedQueue<RPromise<Long>>();
    private final AtomicBoolean isWorkerActive = new AtomicBoolean();

    RedissonIdGenerator(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    private String getAllocationSizeName() {
        return RedissonIdGenerator.suffixName(this.getRawName(), "allocation");
    }

    @Override
    public boolean tryInit(long value, long allocationSize) {
        return this.get(this.tryInitAsync(value, allocationSize));
    }

    @Override
    public long nextId() {
        return this.get(this.nextIdAsync());
    }

    @Override
    public RFuture<Boolean> tryInitAsync(long value, long allocationSize) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('setnx', KEYS[1], ARGV[1]); return redis.call('setnx', KEYS[2], ARGV[2]); ", Arrays.asList(this.getRawName(), this.getAllocationSizeName()), value, allocationSize);
    }

    private void send() {
        if (!this.isWorkerActive.compareAndSet(false, true) || this.commandExecutor.getConnectionManager().getExecutor().isShutdown()) {
            return;
        }
        this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
            while (true) {
                if (this.queue.peek() == null) {
                    this.isWorkerActive.set(false);
                    if (this.queue.isEmpty()) break;
                    this.send();
                    break;
                }
                long v = this.counter.decrementAndGet();
                if (v >= 0L) {
                    RPromise<Long> pp = this.queue.poll();
                    pp.trySuccess(this.start.incrementAndGet());
                    continue;
                }
                try {
                    RFuture future = this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local allocationSize = redis.call('get', KEYS[2]); if allocationSize == false then allocationSize = 5000; redis.call('set', KEYS[2], allocationSize);end;local value = redis.call('get', KEYS[1]); if value == false then redis.call('incr', KEYS[1]);value = 1; end; redis.call('incrby', KEYS[1], allocationSize); return {value, allocationSize}; ", Arrays.asList(this.getRawName(), this.getAllocationSizeName()), new Object[0]);
                    List res = (List)this.get(future);
                    long value = (Long)res.get(0);
                    long allocationSize = (Long)res.get(1);
                    this.start.set(value);
                    this.counter.set(allocationSize);
                    RPromise<Long> pp = this.queue.poll();
                    this.counter.decrementAndGet();
                    pp.trySuccess(this.start.get());
                }
                catch (Exception e) {
                    if (e instanceof RedissonShutdownException) break;
                    this.log.error(e.getMessage(), (Throwable)e);
                    this.isWorkerActive.set(false);
                    this.send();
                    break;
                }
            }
        });
    }

    @Override
    public RFuture<Long> nextIdAsync() {
        RedissonPromise<Long> promise = new RedissonPromise<Long>();
        this.queue.add(promise);
        this.send();
        return promise;
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.getAllocationSizeName());
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        return super.sizeInMemoryAsync(Arrays.asList(this.getRawName(), this.getAllocationSizeName()));
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.expireAsync(timeToLive, timeUnit, this.getRawName(), this.getAllocationSizeName());
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.expireAtAsync(timestamp, this.getRawName(), this.getAllocationSizeName());
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.getAllocationSizeName());
    }
}

