/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal.db;

import org.mybatis.generator.internal.util.StringUtility;

public class ActualTableName {
    private final String tableName;
    private final String catalog;
    private final String schema;
    private final String fullName;

    public ActualTableName(String catalog, String schema, String tableName) {
        this.catalog = catalog;
        this.schema = schema;
        this.tableName = tableName;
        this.fullName = StringUtility.composeFullyQualifiedTableName(catalog, schema, tableName, '.');
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ActualTableName)) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public String toString() {
        return this.fullName;
    }
}

