/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal;

import java.io.File;
import java.util.StringTokenizer;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.exception.ShellException;
import org.mybatis.generator.internal.util.messages.Messages;

public class DefaultShellCallback
implements ShellCallback {
    private final boolean overwrite;

    public DefaultShellCallback(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public File getDirectory(String targetProject, String targetPackage) throws ShellException {
        boolean rc;
        File project = new File(targetProject);
        if (!project.isDirectory()) {
            throw new ShellException(Messages.getString("Warning.9", targetProject));
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(targetPackage, ".");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(File.separatorChar);
        }
        File directory = new File(project, sb.toString());
        if (!directory.isDirectory() && !(rc = directory.mkdirs())) {
            throw new ShellException(Messages.getString("Warning.10", directory.getAbsolutePath()));
        }
        return directory;
    }

    @Override
    public boolean isOverwriteEnabled() {
        return this.overwrite;
    }
}

