/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config;

import java.util.List;
import org.mybatis.generator.internal.db.DatabaseDialects;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class GeneratedKey {
    private final String column;
    private final String runtimeSqlStatement;
    private final boolean isIdentity;
    private final String type;

    public GeneratedKey(String column, String configuredSqlStatement, boolean isIdentity, String type) {
        this.column = column;
        this.type = type;
        this.isIdentity = isIdentity;
        DatabaseDialects dialect = DatabaseDialects.getDatabaseDialect(configuredSqlStatement);
        this.runtimeSqlStatement = dialect == null ? configuredSqlStatement : dialect.getIdentityRetrievalStatement();
    }

    public String getColumn() {
        return this.column;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public String getRuntimeSqlStatement() {
        return this.runtimeSqlStatement;
    }

    public String getMyBatis3Order() {
        return this.isIdentity ? "AFTER" : "BEFORE";
    }

    public void validate(List<String> errors, String tableName) {
        if (!StringUtility.stringHasValue(this.runtimeSqlStatement)) {
            errors.add(Messages.getString("ValidationError.7", tableName));
        }
        if (StringUtility.stringHasValue(this.type) && !"pre".equals(this.type) && !"post".equals(this.type)) {
            errors.add(Messages.getString("ValidationError.15", tableName));
        }
        if ("pre".equals(this.type) && this.isIdentity) {
            errors.add(Messages.getString("ValidationError.23", tableName));
        }
        if ("post".equals(this.type) && !this.isIdentity) {
            errors.add(Messages.getString("ValidationError.24", tableName));
        }
    }

    public boolean isJdbcStandard() {
        return "JDBC".equals(this.runtimeSqlStatement);
    }
}

