/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.mybatis3.javamapper.elements.annotated;

import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.codegen.mybatis3.javamapper.elements.SelectByPrimaryKeyMethodGenerator;
import org.mybatis.generator.internal.util.StringUtility;

public class AnnotatedSelectByPrimaryKeyMethodGenerator
extends SelectByPrimaryKeyMethodGenerator {
    private final boolean useResultMapIfAvailable;

    public AnnotatedSelectByPrimaryKeyMethodGenerator(boolean useResultMapIfAvailable, boolean isSimple) {
        super(isSimple);
        this.useResultMapIfAvailable = useResultMapIfAvailable;
    }

    @Override
    public void addMapperAnnotations(Interface interfaze, Method method) {
        interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Select"));
        this.buildInitialSelectAnnotationStrings().forEach(method::addAnnotation);
        StringBuilder sb = new StringBuilder();
        OutputUtilities.javaIndent(sb, 1);
        sb.append("\"from ");
        sb.append(StringUtility.escapeStringForJava(this.introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime()));
        sb.append("\",");
        method.addAnnotation(sb.toString());
        this.buildByPrimaryKeyWhereClause().forEach(method::addAnnotation);
        method.addAnnotation("})");
        if (this.useResultMapIfAvailable) {
            if (this.introspectedTable.getRules().generateBaseResultMap() || this.introspectedTable.getRules().generateResultMapWithBLOBs()) {
                this.addResultMapAnnotation(method);
            } else {
                this.addAnnotatedResults(interfaze, method, this.introspectedTable.getNonPrimaryKeyColumns());
            }
        } else {
            this.addAnnotatedResults(interfaze, method, this.introspectedTable.getNonPrimaryKeyColumns());
        }
    }

    private void addResultMapAnnotation(Method method) {
        String annotation = String.format("@ResultMap(\"%s.%s\")", this.introspectedTable.getMyBatis3SqlMapNamespace(), this.introspectedTable.getRules().generateResultMapWithBLOBs() ? this.introspectedTable.getResultMapWithBLOBsId() : this.introspectedTable.getBaseResultMapId());
        method.addAnnotation(annotation);
    }

    @Override
    public void addExtraImports(Interface interfaze) {
        interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Select"));
        if (this.useResultMapIfAvailable) {
            if (this.introspectedTable.getRules().generateBaseResultMap() || this.introspectedTable.getRules().generateResultMapWithBLOBs()) {
                interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.ResultMap"));
            } else {
                this.addAnnotationImports(interfaze);
            }
        } else {
            this.addAnnotationImports(interfaze);
        }
    }

    private void addAnnotationImports(Interface interfaze) {
        this.addAnnotatedSelectImports(interfaze);
    }
}

