/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.messages.Messages;

public class RootClassInfo {
    private static final Map<String, RootClassInfo> rootClassInfoMap = Collections.synchronizedMap(new HashMap());
    private PropertyDescriptor[] propertyDescriptors;
    private final String className;
    private final List<String> warnings;
    private boolean genericMode = false;

    public static RootClassInfo getInstance(String className, List<String> warnings) {
        return rootClassInfoMap.computeIfAbsent(className, k -> new RootClassInfo((String)k, warnings));
    }

    public static void reset() {
        rootClassInfoMap.clear();
    }

    private RootClassInfo(String className, List<String> warnings) {
        this.className = className;
        this.warnings = warnings;
        if (className == null) {
            return;
        }
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(className);
        String nameWithoutGenerics = fqjt.getFullyQualifiedNameWithoutTypeParameters();
        if (!nameWithoutGenerics.equals(className)) {
            this.genericMode = true;
        }
        try {
            Class<?> clazz = ObjectFactory.externalClassForName(nameWithoutGenerics);
            BeanInfo bi = Introspector.getBeanInfo(clazz);
            this.propertyDescriptors = bi.getPropertyDescriptors();
        }
        catch (Exception e) {
            this.propertyDescriptors = null;
            warnings.add(Messages.getString("Warning.20", className));
        }
    }

    public boolean containsProperty(IntrospectedColumn introspectedColumn) {
        if (this.propertyDescriptors == null) {
            return false;
        }
        boolean found = false;
        String propertyName = introspectedColumn.getJavaProperty();
        String propertyType = introspectedColumn.getFullyQualifiedJavaType().getFullyQualifiedName();
        for (PropertyDescriptor propertyDescriptor : this.propertyDescriptors) {
            if (!this.hasProperty(propertyName, propertyType, propertyDescriptor)) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean hasProperty(String propertyName, String propertyType, PropertyDescriptor propertyDescriptor) {
        return this.hasCorrectName(propertyName, propertyDescriptor) && this.isProperType(propertyName, propertyType, propertyDescriptor) && this.hasGetter(propertyName, propertyDescriptor) && this.hasSetter(propertyName, propertyDescriptor);
    }

    private boolean hasCorrectName(String propertyName, PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getName().equals(propertyName);
    }

    private boolean isProperType(String propertyName, String propertyType, PropertyDescriptor propertyDescriptor) {
        String introspectedPropertyType = propertyDescriptor.getPropertyType().getName();
        if (this.genericMode && introspectedPropertyType.equals("java.lang.Object")) {
            this.warnings.add(Messages.getString("Warning.28", propertyName, this.className));
        } else if (!introspectedPropertyType.equals(propertyType)) {
            this.warnings.add(Messages.getString("Warning.21", propertyName, this.className, propertyType));
            return false;
        }
        return true;
    }

    private boolean hasGetter(String propertyName, PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.getReadMethod() == null) {
            this.warnings.add(Messages.getString("Warning.22", propertyName, this.className));
            return false;
        }
        return true;
    }

    private boolean hasSetter(String propertyName, PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.getWriteMethod() == null) {
            this.warnings.add(Messages.getString("Warning.23", propertyName, this.className));
            return false;
        }
        return true;
    }
}

