/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.xml;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.ElementVisitor;
import org.mybatis.generator.api.dom.xml.VisitableElement;

public class XmlElement
implements VisitableElement {
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final List<VisitableElement> elements = new ArrayList<VisitableElement>();
    private String name;

    public XmlElement(String name) {
        this.name = name;
    }

    public XmlElement(XmlElement original) {
        this.attributes.addAll(original.attributes);
        this.elements.addAll(original.elements);
        this.name = original.name;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public List<VisitableElement> getElements() {
        return this.elements;
    }

    public void addElement(VisitableElement element) {
        this.elements.add(element);
    }

    public void addElement(int index, VisitableElement element) {
        this.elements.add(index, element);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasChildren() {
        return !this.elements.isEmpty();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public <R> R accept(ElementVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

