/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class ConfigFileLoader {
    private static final URI CATALINA_BASE_URI;

    private ConfigFileLoader() {
    }

    public static InputStream getInputStream(String location) throws IOException {
        URI uri;
        if (location != null && (location.length() > 2 && ":\\".equals(location.substring(1, 3)) || location.startsWith("\\\\"))) {
            File f = new File(location);
            uri = f.getAbsoluteFile().toURI();
        } else {
            uri = CATALINA_BASE_URI.resolve(location);
        }
        URL url = uri.toURL();
        return url.openConnection().getInputStream();
    }

    static {
        File catalinaBase = new File(System.getProperty("catalina.base"));
        CATALINA_BASE_URI = catalinaBase.toURI();
    }
}

