/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.plugin;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.Option;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.internal.exception.VersionNotFoundException;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;

public abstract class AndroidAnnotationsPlugin {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String version;
    private String apiVersion;

    public abstract String getName();

    public abstract List<AnnotationHandler<?>> getHandlers(AndroidAnnotationsEnvironment var1);

    public String toString() {
        return this.getName();
    }

    public List<Option> getSupportedOptions() {
        return Collections.emptyList();
    }

    public boolean shouldCheckApiAndProcessorVersions() {
        return true;
    }

    public final void loadVersion() throws FileNotFoundException, VersionNotFoundException {
        this.version = this.getVersionFromPropertyFile(this.getName().toLowerCase());
        this.apiVersion = this.getVersionFromPropertyFile(this.getName().toLowerCase() + "-api");
    }

    private String getVersionFromPropertyFile(String name) throws FileNotFoundException, VersionNotFoundException {
        Properties properties;
        String filename = name + ".properties";
        try {
            URL url = this.getClass().getClassLoader().getResource(filename);
            properties = new Properties();
            properties.load(url.openStream());
        }
        catch (Exception e) {
            this.logger.error("Property file {} couldn't be parsed", filename);
            throw new FileNotFoundException("Property file " + filename + " couldn't be parsed.");
        }
        String version = properties.getProperty("version");
        if (version == null) {
            this.logger.error("{} plugin is missing 'version' property!", this.getName());
            throw new VersionNotFoundException(this);
        }
        return version;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getVersion() {
        return this.version;
    }
}

