/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.logger.appender;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.androidannotations.logger.Level;
import org.androidannotations.logger.appender.Appender;
import org.androidannotations.logger.formatter.FormatterSimple;

public class MessagerAppender
extends Appender {
    private final List<Message> errors = new LinkedList<Message>();
    private Messager messager;

    public MessagerAppender() {
        super(new FormatterSimple());
    }

    @Override
    public void open() {
        this.messager = this.processingEnv.getMessager();
    }

    @Override
    public void append(Level level, Element element, AnnotationMirror annotationMirror, String message) {
        if (this.messager == null) {
            return;
        }
        Diagnostic.Kind kind = this.resolveKind(level);
        if (!kind.equals((Object)Diagnostic.Kind.ERROR)) {
            this.messager.printMessage(kind, message, element, annotationMirror);
        } else {
            this.errors.add(new Message(kind, message, element, annotationMirror));
        }
    }

    @Override
    public synchronized void close(boolean lastRound) {
        if (lastRound) {
            for (Message error : this.errors) {
                ElementDetails elementDetails = error.getElementDetails();
                this.messager.printMessage(error.kind, error.message, elementDetails.getElement(), elementDetails.getAnnotationMirror());
            }
        }
    }

    private Diagnostic.Kind resolveKind(Level level) {
        switch (level) {
            case TRACE: {
                return Diagnostic.Kind.NOTE;
            }
            case DEBUG: {
                return Diagnostic.Kind.NOTE;
            }
            case INFO: {
                return Diagnostic.Kind.NOTE;
            }
            case WARN: {
                return Diagnostic.Kind.WARNING;
            }
            case ERROR: {
                return Diagnostic.Kind.ERROR;
            }
        }
        return Diagnostic.Kind.OTHER;
    }

    private static class ElementDetails {
        private final Element element;
        private final AnnotationMirror annotationMirror;

        ElementDetails(Element element, AnnotationMirror annotationMirror) {
            this.element = element;
            this.annotationMirror = annotationMirror;
        }

        public Element getElement() {
            return this.element;
        }

        public AnnotationMirror getAnnotationMirror() {
            return this.annotationMirror;
        }
    }

    private class Message {
        private final Diagnostic.Kind kind;
        private final String message;
        private final String annotationMirrorString;
        private final List<String> elements = new LinkedList<String>();

        Message(Diagnostic.Kind kind, String message, Element element, AnnotationMirror annotationMirror) {
            this.kind = kind;
            this.message = message;
            String string = this.annotationMirrorString = annotationMirror == null ? null : annotationMirror.toString();
            if (element != null) {
                Element enclosingElement = element;
                do {
                    this.elements.add(0, enclosingElement.toString());
                } while (!(enclosingElement = enclosingElement.getEnclosingElement()).getKind().equals((Object)ElementKind.PACKAGE));
            }
        }

        private AnnotationMirror getAnnotationMirror(Element element) {
            if (element == null) {
                return null;
            }
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.toString().equals(this.annotationMirrorString)) continue;
                return annotationMirror;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private Element getElement() {
            if (this.elements.isEmpty()) {
                return null;
            }
            boolean ignorePackage = false;
            LinkedList<String> localElements = new LinkedList<String>(this.elements);
            Element element = MessagerAppender.this.processingEnv.getElementUtils().getTypeElement((CharSequence)localElements.remove(0));
            while (localElements.size() > 0) {
                int prevSize = localElements.size();
                if (element instanceof ExecutableElement) {
                    ExecutableElement method = (ExecutableElement)element;
                    for (VariableElement variableElement : method.getParameters()) {
                        if (!variableElement.toString().equals(localElements.get(0))) continue;
                        localElements.remove(0);
                        element = variableElement;
                        break;
                    }
                } else {
                    for (Element element2 : element.getEnclosedElements()) {
                        void var7_13;
                        String string = element2.toString();
                        String localElement = (String)localElements.get(0);
                        if (ignorePackage) {
                            String string2 = this.removePackages(string);
                            localElement = this.removePackages(localElement);
                        }
                        if (!var7_13.equals(localElement)) continue;
                        localElements.remove(0);
                        element = element2;
                        break;
                    }
                }
                if (prevSize != localElements.size()) continue;
                if (ignorePackage) {
                    return element;
                }
                ignorePackage = true;
            }
            return element;
        }

        private String removePackages(String elemStringValue) {
            return elemStringValue.replaceAll("([a-zA-Z_$][a-zA-Z_$0-9]*\\.)+", "");
        }

        private ElementDetails getElementDetails() {
            Element element = this.getElement();
            return new ElementDetails(element, this.getAnnotationMirror(element));
        }
    }
}

