/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.logger.appender;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.Option;
import org.androidannotations.internal.helper.FileHelper;
import org.androidannotations.logger.Level;
import org.androidannotations.logger.LoggerContext;
import org.androidannotations.logger.appender.Appender;
import org.androidannotations.logger.formatter.FormatterFull;

public class FileAppender
extends Appender {
    public static final Option OPTION_LOG_FILE = new Option("logFile", null);
    private static final String DEFAULT_FILENAME = "androidannotations.log";
    private File file;
    private FileOutputStream outputStream;

    public FileAppender() {
        super(new FormatterFull());
    }

    @Override
    public synchronized void open() {
        if (!this.isStreamOpened()) {
            try {
                this.outputStream = new FileOutputStream(this.file, true);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void close(boolean lastRound) {
        if (this.isStreamOpened()) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.outputStream = null;
        }
    }

    @Override
    public synchronized void append(Level level, Element element, AnnotationMirror annotationMirror, String message) {
        if (this.isStreamOpened()) {
            try {
                message = message + "\n";
                this.outputStream.write(message.getBytes());
                this.outputStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setEnvironment(AndroidAnnotationsEnvironment environment) {
        super.setEnvironment(environment);
        this.resolveLogFile(environment);
    }

    private void resolveLogFile(AndroidAnnotationsEnvironment environment) {
        String logFile = environment.getOptionValue(OPTION_LOG_FILE);
        try {
            this.file = logFile != null ? this.resolveLogFileInSpecifiedPath(logFile) : this.resolveLogFileInParentsDirectories();
        }
        catch (FileNotFoundException exception) {
            this.file = null;
        }
        Level logLevel = LoggerContext.getInstance().getCurrentLevel();
        Messager messager = this.processingEnv.getMessager();
        if (this.file == null) {
            if (Level.WARN.isGreaterOrEquals(logLevel)) {
                messager.printMessage(Diagnostic.Kind.WARNING, "Can't resolve log file");
            }
        } else if (Level.INFO.isGreaterOrEquals(logLevel)) {
            messager.printMessage(Diagnostic.Kind.NOTE, "Resolve log file to " + this.file.getAbsolutePath());
        }
    }

    private File resolveLogFileInSpecifiedPath(String logFile) throws FileNotFoundException {
        File outputDirectory = FileHelper.resolveOutputDirectory(this.processingEnv);
        logFile = logFile.replace("{outputFolder}", outputDirectory.getAbsolutePath());
        return new File(logFile);
    }

    private File resolveLogFileInParentsDirectories() throws FileNotFoundException {
        File outputDirectory = FileHelper.resolveOutputDirectory(this.processingEnv);
        return new File(outputDirectory, DEFAULT_FILENAME);
    }

    private boolean isStreamOpened() {
        return this.outputStream != null;
    }
}

