/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.logger;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.Option;
import org.androidannotations.logger.Level;
import org.androidannotations.logger.appender.Appender;
import org.androidannotations.logger.appender.ConsoleAppender;
import org.androidannotations.logger.appender.FileAppender;
import org.androidannotations.logger.appender.MessagerAppender;
import org.androidannotations.logger.formatter.Formatter;

public final class LoggerContext {
    public static final Option OPTION_LOG_LEVEL = new Option("logLevel", "WARN");
    public static final Option OPTION_LOG_APPENDER_CONSOLE = new Option("logAppenderConsole", "false");
    public static final Option OPTION_LOG_APPENDER_FILE = new Option("logAppenderFile", "true");
    private static LoggerContext instance = null;
    private static final Level DEFAULT_LEVEL = Level.WARN;
    private Level currentLevel = DEFAULT_LEVEL;
    private List<Appender> appenders = new ArrayList<Appender>();

    private LoggerContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoggerContext getInstance() {
        if (instance != null) return instance;
        Class<LoggerContext> clazz = LoggerContext.class;
        synchronized (LoggerContext.class) {
            if (instance != null) return instance;
            instance = new LoggerContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void writeLog(Level level, String loggerName, String message, Element element, AnnotationMirror annotationMirror, Throwable thr, Object ... args) {
        for (Appender appender : this.appenders) {
            Formatter formatter = appender.getFormatter();
            String log = formatter.buildLog(level, loggerName, message, thr, args);
            appender.append(level, element, annotationMirror, log);
        }
    }

    public Level getCurrentLevel() {
        return this.currentLevel;
    }

    public void setCurrentLevel(Level currentLevel) {
        this.currentLevel = currentLevel;
    }

    public void setEnvironment(AndroidAnnotationsEnvironment environment) {
        this.appenders.clear();
        this.resolveLogLevel(environment);
        this.addConsoleAppender(environment);
        this.addFileAppender(environment);
        this.appenders.add(new MessagerAppender());
        for (Appender appender : this.appenders) {
            appender.setEnvironment(environment);
            appender.open();
        }
    }

    public void close(boolean lastRound) {
        for (Appender appender : this.appenders) {
            appender.close(lastRound);
        }
    }

    private void resolveLogLevel(AndroidAnnotationsEnvironment environment) {
        Level level = Level.WARN;
        try {
            level = Level.parse(environment.getOptionValue(OPTION_LOG_LEVEL));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCurrentLevel(level);
    }

    private void addConsoleAppender(AndroidAnnotationsEnvironment environment) {
        if (environment.getOptionBooleanValue(OPTION_LOG_APPENDER_CONSOLE)) {
            this.appenders.add(new ConsoleAppender());
        }
    }

    private void addFileAppender(AndroidAnnotationsEnvironment environment) {
        if (environment.getOptionBooleanValue(OPTION_LOG_APPENDER_FILE)) {
            this.appenders.add(new FileAppender());
        }
    }
}

