/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.logger;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.androidannotations.logger.Level;
import org.androidannotations.logger.LoggerContext;

public class Logger {
    private final LoggerContext loggerContext;
    private final String name;

    public Logger(LoggerContext loggerContext, String name) {
        this.loggerContext = loggerContext;
        this.name = name;
    }

    public void trace(String message, Object ... args) {
        this.log(Level.TRACE, message, null, null, null, args);
    }

    public void debug(String message, Object ... args) {
        this.log(Level.DEBUG, message, null, null, null, args);
    }

    public void info(String message, Object ... args) {
        this.log(Level.INFO, message, null, null, null, args);
    }

    public void warn(String message, Object ... args) {
        this.warn(null, message, args);
    }

    public void warn(Element element, String message, Object ... args) {
        this.log(Level.WARN, message, element, null, null, args);
    }

    public void warn(Element element, AnnotationMirror annotationMirror, String message) {
        this.log(Level.WARN, message, element, annotationMirror, null, new Object[0]);
    }

    public void error(String message, Object ... args) {
        this.error(null, null, message, args);
    }

    public void error(Element element, String message, Object ... args) {
        this.error(element, null, message, args);
    }

    public void error(Throwable thr, String message, Object ... args) {
        this.error(null, thr, message, args);
    }

    public void error(Element element, Throwable thr, String message, Object ... args) {
        this.log(Level.ERROR, message, element, null, thr, args);
    }

    public void error(Element element, AnnotationMirror annotationMirror, String message) {
        this.log(Level.ERROR, message, element, annotationMirror, null, new Object[0]);
    }

    public boolean isLoggable(Level level) {
        return level.isGreaterOrEquals(this.loggerContext.getCurrentLevel());
    }

    private void log(Level level, String message, Element element, AnnotationMirror annotationMirror, Throwable thr, Object ... args) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.loggerContext.writeLog(level, this.name, message, element, annotationMirror, thr, args);
    }
}

