/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.rclass;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JDirectClass;
import com.helger.jcodemodel.JFieldRef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.rclass.IRInnerClass;

public class RInnerClass
implements IRInnerClass {
    private final Map<Integer, String> idQualifiedNamesByIdValues = new HashMap<Integer, String>();
    private final Set<String> idQualifiedNames = new HashSet<String>();
    private final String rInnerQualifiedName;

    public RInnerClass(TypeElement rInnerTypeElement) {
        if (rInnerTypeElement != null) {
            this.rInnerQualifiedName = rInnerTypeElement.getQualifiedName().toString();
            List<? extends Element> idEnclosedElements = rInnerTypeElement.getEnclosedElements();
            List<VariableElement> idFields = ElementFilter.fieldsIn(idEnclosedElements);
            for (VariableElement idField : idFields) {
                TypeKind fieldType = idField.asType().getKind();
                if (!fieldType.isPrimitive() || !fieldType.equals((Object)TypeKind.INT)) continue;
                String idQualifiedName = this.rInnerQualifiedName + "." + idField.getSimpleName();
                this.idQualifiedNames.add(idQualifiedName);
                Integer idFieldId = (Integer)idField.getConstantValue();
                if (idFieldId == null) continue;
                this.idQualifiedNamesByIdValues.put(idFieldId, idQualifiedName);
            }
        } else {
            this.rInnerQualifiedName = "";
        }
    }

    @Override
    public boolean containsIdValue(Integer idValue) {
        return this.idQualifiedNamesByIdValues.containsKey(idValue);
    }

    @Override
    public String getIdQualifiedName(Integer idValue) {
        return this.idQualifiedNamesByIdValues.get(idValue);
    }

    @Override
    public boolean containsField(String name) {
        boolean containsField = this.idQualifiedNames.contains(this.rInnerQualifiedName + "." + name);
        if (!containsField) {
            String snakeCaseName = CaseHelper.camelCaseToSnakeCase(name);
            containsField = this.idQualifiedNames.contains(this.rInnerQualifiedName + "." + snakeCaseName);
        }
        return containsField;
    }

    @Override
    public String getIdQualifiedName(String name) {
        String idQualifiedName = this.rInnerQualifiedName + "." + name;
        if (this.idQualifiedNames.contains(idQualifiedName)) {
            return idQualifiedName;
        }
        String snakeCaseName = CaseHelper.camelCaseToSnakeCase(name);
        idQualifiedName = this.rInnerQualifiedName + "." + snakeCaseName;
        if (this.idQualifiedNames.contains(idQualifiedName)) {
            return idQualifiedName;
        }
        return null;
    }

    @Override
    public JFieldRef getIdStaticRef(Integer idValue, AndroidAnnotationsEnvironment environment) {
        String layoutFieldQualifiedName = this.getIdQualifiedName(idValue);
        return RInnerClass.extractIdStaticRef(environment, layoutFieldQualifiedName);
    }

    @Override
    public JFieldRef getIdStaticRef(String name, AndroidAnnotationsEnvironment environment) {
        String layoutFieldQualifiedName = this.getIdQualifiedName(name);
        return RInnerClass.extractIdStaticRef(environment, layoutFieldQualifiedName);
    }

    public static JFieldRef extractIdStaticRef(AndroidAnnotationsEnvironment environment, String layoutFieldQualifiedName) {
        if (layoutFieldQualifiedName != null) {
            int fieldSuffix = layoutFieldQualifiedName.lastIndexOf(46);
            String fieldName = layoutFieldQualifiedName.substring(fieldSuffix + 1);
            String rInnerClassName = layoutFieldQualifiedName.substring(0, fieldSuffix);
            int innerClassSuffix = rInnerClassName.lastIndexOf(46);
            String rClassQualifiedName = rInnerClassName.substring(0, innerClassSuffix);
            String innerClassSimpleName = rInnerClassName.substring(innerClassSuffix + 1);
            if (rClassQualifiedName.endsWith("R2")) {
                rClassQualifiedName = rClassQualifiedName.substring(0, rClassQualifiedName.length() - 1);
            }
            JDirectClass rClass = (JDirectClass)environment.getJClass(rClassQualifiedName);
            AbstractJClass innerClass = null;
            for (JDirectClass clazz : rClass.classes()) {
                if (!clazz.name().equals(innerClassSimpleName)) continue;
                innerClass = clazz;
                break;
            }
            if (innerClass == null) {
                try {
                    innerClass = (AbstractJClass)rClass._class(innerClassSimpleName);
                }
                catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
                    // empty catch block
                }
            }
            return innerClass.staticRef(fieldName);
        }
        return null;
    }
}

