/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.rclass;

import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.Option;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.internal.exception.RClassNotFoundException;
import org.androidannotations.internal.rclass.RClass;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;
import org.androidannotations.rclass.IRClass;

public class ProjectRClassFinder {
    public static final Option OPTION_RESOURCE_PACKAGE_NAME = new Option("resourcePackageName", null);
    public static final Option OPTION_USE_R2 = new Option("useR2", "false");
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectRClassFinder.class);
    private AndroidAnnotationsEnvironment environment;

    public ProjectRClassFinder(AndroidAnnotationsEnvironment environment) {
        this.environment = environment;
    }

    public IRClass find(AndroidManifest manifest) throws RClassNotFoundException {
        String rClass;
        Elements elementUtils = this.environment.getProcessingEnvironment().getElementUtils();
        TypeElement rType = elementUtils.getTypeElement(rClass = this.getRClassPackageName(manifest) + "." + this.getRClassSimpleName());
        if (rType == null) {
            LOGGER.error("The generated {} class cannot be found", rClass);
            throw new RClassNotFoundException("The generated " + rClass + " class cannot be found");
        }
        LOGGER.info("Found project R class: {}", rType.toString());
        return new RClass(rType);
    }

    public String getRClassPackageName(AndroidManifest manifest) {
        String resourcePackageName = this.environment.getOptionValue(OPTION_RESOURCE_PACKAGE_NAME);
        if (resourcePackageName != null) {
            return resourcePackageName;
        }
        return manifest.getApplicationPackage();
    }

    private String getRClassSimpleName() {
        boolean useR2 = this.environment.getOptionBooleanValue(OPTION_USE_R2);
        return useR2 ? "R2" : "R";
    }
}

