/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.rclass;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.androidannotations.internal.exception.RClassNotFoundException;
import org.androidannotations.internal.rclass.RClass;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;
import org.androidannotations.rclass.IRClass;

public class AndroidRClassFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AndroidRClassFinder.class);
    private final ProcessingEnvironment processingEnv;

    public AndroidRClassFinder(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public IRClass find() throws RClassNotFoundException {
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement androidRType = elementUtils.getTypeElement("android.R");
        if (androidRType == null) {
            LOGGER.error("The android.R class cannot be found", new Object[0]);
            throw new RClassNotFoundException("The android.R class cannot be found");
        }
        LOGGER.info("Found Android class: {}", androidRType.toString());
        return new RClass(androidRType);
    }
}

