/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.process;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.internal.process.OriginatingElements;

public class ProcessHolder {
    private final Map<Element, GeneratedClassHolder> generatedClassHolders = new HashMap<Element, GeneratedClassHolder>();
    private final ProcessingEnvironment processingEnvironment;
    private final JCodeModel codeModel;
    private final Map<String, AbstractJClass> loadedClasses = new HashMap<String, AbstractJClass>();
    private final Classes classes;
    private final OriginatingElements originatingElements = new OriginatingElements();

    public ProcessHolder(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.codeModel = new JCodeModel();
        this.codeModel.addDontImportClass(this.refClass("android.R"));
        this.classes = new Classes();
    }

    public void put(Element element, GeneratedClassHolder generatedClassHolder) {
        JDefinedClass generatedClass = generatedClassHolder.getGeneratedClass();
        String qualifiedName = generatedClass.fullName();
        this.originatingElements.add(qualifiedName, element);
        this.generatedClassHolders.put(element, generatedClassHolder);
    }

    public GeneratedClassHolder getGeneratedClassHolder(Element element) {
        for (Element key : this.generatedClassHolders.keySet()) {
            if (!key.asType().toString().equals(element.asType().toString())) continue;
            return this.generatedClassHolders.get(key);
        }
        return null;
    }

    public AbstractJClass refClass(Class<?> clazz) {
        AbstractJClass referencedClass = this.codeModel.ref(clazz);
        this.loadedClasses.put(clazz.getCanonicalName(), referencedClass);
        return referencedClass;
    }

    public AbstractJClass refClass(String fullyQualifiedClassName) {
        int arrayCounter = 0;
        while (fullyQualifiedClassName.endsWith("[]")) {
            ++arrayCounter;
            fullyQualifiedClassName = fullyQualifiedClassName.substring(0, fullyQualifiedClassName.length() - 2);
        }
        AbstractJClass refClass = this.loadedClasses.get(fullyQualifiedClassName);
        if (refClass == null) {
            refClass = this.codeModel.directClass(fullyQualifiedClassName);
            this.loadedClasses.put(fullyQualifiedClassName, refClass);
        }
        for (int i = 0; i < arrayCounter; ++i) {
            refClass = refClass.array();
        }
        return refClass;
    }

    public JDefinedClass definedClass(String fullyQualifiedClassName) {
        JDefinedClass refClass = (JDefinedClass)this.loadedClasses.get(fullyQualifiedClassName);
        if (refClass == null) {
            try {
                refClass = this.codeModel._class(fullyQualifiedClassName);
            }
            catch (JClassAlreadyExistsException e) {
                refClass = (JDefinedClass)this.refClass(fullyQualifiedClassName);
            }
            this.loadedClasses.put(fullyQualifiedClassName, (AbstractJClass)refClass);
        }
        return refClass;
    }

    public ProcessingEnvironment processingEnvironment() {
        return this.processingEnvironment;
    }

    public JCodeModel codeModel() {
        return this.codeModel;
    }

    public Classes classes() {
        return this.classes;
    }

    public OriginatingElements getOriginatingElements() {
        return this.originatingElements;
    }

    public class Classes {
        public final AbstractJClass RUNTIME_EXCEPTION;
        public final AbstractJClass EXCEPTION;
        public final AbstractJClass THROWABLE;
        public final AbstractJClass CHAR_SEQUENCE;
        public final AbstractJClass CLASS_CAST_EXCEPTION;
        public final AbstractJClass SERIALIZABLE;
        public final AbstractJClass STRING;
        public final AbstractJClass STRING_BUILDER;
        public final AbstractJClass SYSTEM;
        public final AbstractJClass INPUT_STREAM;
        public final AbstractJClass FILE_INPUT_STREAM;
        public final AbstractJClass SQL_EXCEPTION;
        public final AbstractJClass COLLECTIONS;
        public final AbstractJClass THREAD;
        public final AbstractJClass HASH_MAP;
        public final AbstractJClass LIST;
        public final AbstractJClass OBJECT;
        public final AbstractJClass ARRAYS;
        public final AbstractJClass HASH_SET;
        public final AbstractJClass LOG;
        public final AbstractJClass BUNDLE;
        public final AbstractJClass ACTIVITY;
        public final AbstractJClass EDITABLE;
        public final AbstractJClass TEXT_WATCHER;
        public final AbstractJClass SEEKBAR;
        public final AbstractJClass ON_SEEKBAR_CHANGE_LISTENER;
        public final AbstractJClass TEXT_VIEW;
        public final AbstractJClass TEXT_VIEW_ON_EDITOR_ACTION_LISTENER;
        public final AbstractJClass COMPOUND_BUTTON;
        public final AbstractJClass COMPOUND_BUTTON_ON_CHECKED_CHANGE_LISTENER;
        public final AbstractJClass VIEW;
        public final AbstractJClass VIEW_ON_CLICK_LISTENER;
        public final AbstractJClass VIEW_ON_TOUCH_LISTENER;
        public final AbstractJClass VIEW_ON_LONG_CLICK_LISTENER;
        public final AbstractJClass VIEW_ON_FOCUS_CHANGE_LISTENER;
        public final AbstractJClass VIEW_GROUP_LAYOUT_PARAMS;
        public final AbstractJClass KEY_EVENT;
        public final AbstractJClass CONTEXT;
        public final AbstractJClass INTENT;
        public final AbstractJClass INTENT_FILTER;
        public final AbstractJClass BROADCAST_RECEIVER;
        public final AbstractJClass LOCAL_BROADCAST_MANAGER;
        public final AbstractJClass COMPONENT_NAME;
        public final AbstractJClass VIEW_GROUP;
        public final AbstractJClass LAYOUT_INFLATER;
        public final AbstractJClass FRAGMENT_ACTIVITY;
        public final AbstractJClass FRAGMENT;
        public final AbstractJClass SUPPORT_V4_FRAGMENT;
        public final AbstractJClass HTML;
        public final AbstractJClass WINDOW_MANAGER_LAYOUT_PARAMS;
        public final AbstractJClass ADAPTER_VIEW;
        public final AbstractJClass ON_ITEM_LONG_CLICK_LISTENER;
        public final AbstractJClass ON_ITEM_CLICK_LISTENER;
        public final AbstractJClass ON_ITEM_SELECTED_LISTENER;
        public final AbstractJClass WINDOW;
        public final AbstractJClass MENU_ITEM;
        public final AbstractJClass MENU_INFLATER;
        public final AbstractJClass MENU;
        public final AbstractJClass ANIMATION_UTILS;
        public final AbstractJClass RESOURCES;
        public final AbstractJClass CONFIGURATION;
        public final AbstractJClass MOTION_EVENT;
        public final AbstractJClass HANDLER;
        public final AbstractJClass KEY_STORE;
        public final AbstractJClass VIEW_SERVER;
        public final AbstractJClass PARCELABLE;
        public final AbstractJClass LOOPER;
        public final AbstractJClass POWER_MANAGER;
        public final AbstractJClass WAKE_LOCK;
        public final AbstractJClass BUILD_VERSION;
        public final AbstractJClass BUILD_VERSION_CODES;
        public final AbstractJClass ACTIVITY_COMPAT;
        public final AbstractJClass CONTEXT_COMPAT;
        public final AbstractJClass APP_WIDGET_MANAGER;
        public final AbstractJClass VIEW_PAGER;
        public final AbstractJClass PAGE_CHANGE_LISTENER;
        public final AbstractJClass PREFERENCE;
        public final AbstractJClass SUPPORT_V7_PREFERENCE;
        public final AbstractJClass PREFERENCE_CHANGE_LISTENER;
        public final AbstractJClass SUPPORT_V7_PREFERENCE_CHANGE_LISTENER;
        public final AbstractJClass PREFERENCE_CLICK_LISTENER;
        public final AbstractJClass SUPPORT_V7_PREFERENCE_CLICK_LISTENER;
        public final AbstractJClass PREFERENCE_ACTIVITY_HEADER;
        public final AbstractJClass VIEW_DATA_BINDING;
        public final AbstractJClass DATA_BINDING_UTIL;
        public final AbstractJClass ANDROIDX_ACTIVITY_COMPAT;
        public final AbstractJClass ANDROIDX_FRAGMENT;
        public final AbstractJClass ANDROIDX_FRAGMENT_ACTIVITY;
        public final AbstractJClass ANDROIDX_LOCAL_BROADCAST_MANAGER;
        public final AbstractJClass ANDROIDX_CONTEXT_COMPAT;
        public final AbstractJClass ANDROIDX_PREFERENCE;
        public final AbstractJClass ANDROIDX_PREFERENCE_CLICK_LISTENER;
        public final AbstractJClass ANDROIDX_PREFERENCE_CHANGE_LISTENER;
        public final AbstractJClass ANDROIDX_VIEW_PAGER;
        public final AbstractJClass ANDROIDX_PAGE_CHANGE_LISTENER;
        public final AbstractJClass ANDROIDX_VIEW_DATA_BINDING;
        public final AbstractJClass ANDROIDX_DATA_BINDING_UTIL;
        public final AbstractJClass CLIENT_CONNECTION_MANAGER;
        public final AbstractJClass DEFAULT_HTTP_CLIENT;
        public final AbstractJClass SSL_SOCKET_FACTORY;
        public final AbstractJClass PLAIN_SOCKET_FACTORY;
        public final AbstractJClass SCHEME;
        public final AbstractJClass SCHEME_REGISTRY;
        public final AbstractJClass SINGLE_CLIENT_CONN_MANAGER;

        public Classes() {
            this.RUNTIME_EXCEPTION = ProcessHolder.this.refClass(RuntimeException.class);
            this.EXCEPTION = ProcessHolder.this.refClass(Exception.class);
            this.THROWABLE = ProcessHolder.this.refClass(Throwable.class);
            this.CHAR_SEQUENCE = ProcessHolder.this.refClass(CharSequence.class);
            this.CLASS_CAST_EXCEPTION = ProcessHolder.this.refClass(ClassCastException.class);
            this.SERIALIZABLE = ProcessHolder.this.refClass(Serializable.class);
            this.STRING = ProcessHolder.this.refClass(String.class);
            this.STRING_BUILDER = ProcessHolder.this.refClass(StringBuilder.class);
            this.SYSTEM = ProcessHolder.this.refClass(System.class);
            this.INPUT_STREAM = ProcessHolder.this.refClass(InputStream.class);
            this.FILE_INPUT_STREAM = ProcessHolder.this.refClass(FileInputStream.class);
            this.SQL_EXCEPTION = ProcessHolder.this.refClass(SQLException.class);
            this.COLLECTIONS = ProcessHolder.this.refClass(Collections.class);
            this.THREAD = ProcessHolder.this.refClass(Thread.class);
            this.HASH_MAP = ProcessHolder.this.refClass(HashMap.class);
            this.LIST = ProcessHolder.this.refClass(List.class);
            this.OBJECT = ProcessHolder.this.refClass(Object.class);
            this.ARRAYS = ProcessHolder.this.refClass(Arrays.class);
            this.HASH_SET = ProcessHolder.this.refClass(HashSet.class);
            this.LOG = ProcessHolder.this.refClass("android.util.Log");
            this.BUNDLE = ProcessHolder.this.refClass("android.os.Bundle");
            this.ACTIVITY = ProcessHolder.this.refClass("android.app.Activity");
            this.EDITABLE = ProcessHolder.this.refClass("android.text.Editable");
            this.TEXT_WATCHER = ProcessHolder.this.refClass("android.text.TextWatcher");
            this.SEEKBAR = ProcessHolder.this.refClass("android.widget.SeekBar");
            this.ON_SEEKBAR_CHANGE_LISTENER = ProcessHolder.this.refClass("android.widget.SeekBar.OnSeekBarChangeListener");
            this.TEXT_VIEW = ProcessHolder.this.refClass("android.widget.TextView");
            this.TEXT_VIEW_ON_EDITOR_ACTION_LISTENER = ProcessHolder.this.refClass("android.widget.TextView.OnEditorActionListener");
            this.COMPOUND_BUTTON = ProcessHolder.this.refClass("android.widget.CompoundButton");
            this.COMPOUND_BUTTON_ON_CHECKED_CHANGE_LISTENER = ProcessHolder.this.refClass("android.widget.CompoundButton.OnCheckedChangeListener");
            this.VIEW = ProcessHolder.this.refClass("android.view.View");
            this.VIEW_ON_CLICK_LISTENER = ProcessHolder.this.refClass("android.view.View.OnClickListener");
            this.VIEW_ON_TOUCH_LISTENER = ProcessHolder.this.refClass("android.view.View.OnTouchListener");
            this.VIEW_ON_LONG_CLICK_LISTENER = ProcessHolder.this.refClass("android.view.View.OnLongClickListener");
            this.VIEW_ON_FOCUS_CHANGE_LISTENER = ProcessHolder.this.refClass("android.view.View.OnFocusChangeListener");
            this.VIEW_GROUP_LAYOUT_PARAMS = ProcessHolder.this.refClass("android.view.ViewGroup.LayoutParams");
            this.KEY_EVENT = ProcessHolder.this.refClass("android.view.KeyEvent");
            this.CONTEXT = ProcessHolder.this.refClass("android.content.Context");
            this.INTENT = ProcessHolder.this.refClass("android.content.Intent");
            this.INTENT_FILTER = ProcessHolder.this.refClass("android.content.IntentFilter");
            this.BROADCAST_RECEIVER = ProcessHolder.this.refClass("android.content.BroadcastReceiver");
            this.LOCAL_BROADCAST_MANAGER = ProcessHolder.this.refClass("android.support.v4.content.LocalBroadcastManager");
            this.COMPONENT_NAME = ProcessHolder.this.refClass("android.content.ComponentName");
            this.VIEW_GROUP = ProcessHolder.this.refClass("android.view.ViewGroup");
            this.LAYOUT_INFLATER = ProcessHolder.this.refClass("android.view.LayoutInflater");
            this.FRAGMENT_ACTIVITY = ProcessHolder.this.refClass("android.support.v4.app.FragmentActivity");
            this.FRAGMENT = ProcessHolder.this.refClass("android.app.Fragment");
            this.SUPPORT_V4_FRAGMENT = ProcessHolder.this.refClass("android.support.v4.app.Fragment");
            this.HTML = ProcessHolder.this.refClass("android.text.Html");
            this.WINDOW_MANAGER_LAYOUT_PARAMS = ProcessHolder.this.refClass("android.view.WindowManager.LayoutParams");
            this.ADAPTER_VIEW = ProcessHolder.this.refClass("android.widget.AdapterView");
            this.ON_ITEM_LONG_CLICK_LISTENER = ProcessHolder.this.refClass("android.widget.AdapterView.OnItemLongClickListener");
            this.ON_ITEM_CLICK_LISTENER = ProcessHolder.this.refClass("android.widget.AdapterView.OnItemClickListener");
            this.ON_ITEM_SELECTED_LISTENER = ProcessHolder.this.refClass("android.widget.AdapterView.OnItemSelectedListener");
            this.WINDOW = ProcessHolder.this.refClass("android.view.Window");
            this.MENU_ITEM = ProcessHolder.this.refClass("android.view.MenuItem");
            this.MENU_INFLATER = ProcessHolder.this.refClass("android.view.MenuInflater");
            this.MENU = ProcessHolder.this.refClass("android.view.Menu");
            this.ANIMATION_UTILS = ProcessHolder.this.refClass("android.view.animation.AnimationUtils");
            this.RESOURCES = ProcessHolder.this.refClass("android.content.res.Resources");
            this.CONFIGURATION = ProcessHolder.this.refClass("android.content.res.Configuration");
            this.MOTION_EVENT = ProcessHolder.this.refClass("android.view.MotionEvent");
            this.HANDLER = ProcessHolder.this.refClass("android.os.Handler");
            this.KEY_STORE = ProcessHolder.this.refClass("java.security.KeyStore");
            this.VIEW_SERVER = ProcessHolder.this.refClass("org.androidannotations.api.ViewServer");
            this.PARCELABLE = ProcessHolder.this.refClass("android.os.Parcelable");
            this.LOOPER = ProcessHolder.this.refClass("android.os.Looper");
            this.POWER_MANAGER = ProcessHolder.this.refClass("android.os.PowerManager");
            this.WAKE_LOCK = ProcessHolder.this.refClass("android.os.PowerManager.WakeLock");
            this.BUILD_VERSION = ProcessHolder.this.refClass("android.os.Build.VERSION");
            this.BUILD_VERSION_CODES = ProcessHolder.this.refClass("android.os.Build.VERSION_CODES");
            this.ACTIVITY_COMPAT = ProcessHolder.this.refClass("android.support.v4.app.ActivityCompat");
            this.CONTEXT_COMPAT = ProcessHolder.this.refClass("android.support.v4.content.ContextCompat");
            this.APP_WIDGET_MANAGER = ProcessHolder.this.refClass("android.appwidget.AppWidgetManager");
            this.VIEW_PAGER = ProcessHolder.this.refClass("android.support.v4.view.ViewPager");
            this.PAGE_CHANGE_LISTENER = ProcessHolder.this.refClass("android.support.v4.view.ViewPager.OnPageChangeListener");
            this.PREFERENCE = ProcessHolder.this.refClass("android.preference.Preference");
            this.SUPPORT_V7_PREFERENCE = ProcessHolder.this.refClass("android.support.v7.preference.Preference");
            this.PREFERENCE_CHANGE_LISTENER = ProcessHolder.this.refClass("android.preference.Preference.OnPreferenceChangeListener");
            this.SUPPORT_V7_PREFERENCE_CHANGE_LISTENER = ProcessHolder.this.refClass("android.support.v7.preference.Preference.OnPreferenceChangeListener");
            this.PREFERENCE_CLICK_LISTENER = ProcessHolder.this.refClass("android.preference.Preference.OnPreferenceClickListener");
            this.SUPPORT_V7_PREFERENCE_CLICK_LISTENER = ProcessHolder.this.refClass("android.support.v7.preference.Preference.OnPreferenceClickListener");
            this.PREFERENCE_ACTIVITY_HEADER = ProcessHolder.this.refClass("android.preference.PreferenceActivity.Header");
            this.VIEW_DATA_BINDING = ProcessHolder.this.refClass("android.databinding.ViewDataBinding");
            this.DATA_BINDING_UTIL = ProcessHolder.this.refClass("android.databinding.DataBindingUtil");
            this.ANDROIDX_ACTIVITY_COMPAT = ProcessHolder.this.refClass("androidx.core.app.ActivityCompat");
            this.ANDROIDX_FRAGMENT = ProcessHolder.this.refClass("androidx.fragment.app.Fragment");
            this.ANDROIDX_FRAGMENT_ACTIVITY = ProcessHolder.this.refClass("androidx.fragment.app.FragmentActivity");
            this.ANDROIDX_LOCAL_BROADCAST_MANAGER = ProcessHolder.this.refClass("androidx.localbroadcastmanager.content.LocalBroadcastManager");
            this.ANDROIDX_CONTEXT_COMPAT = ProcessHolder.this.refClass("androidx.core.content.ContextCompat");
            this.ANDROIDX_PREFERENCE = ProcessHolder.this.refClass("androidx.preference.Preference");
            this.ANDROIDX_PREFERENCE_CLICK_LISTENER = ProcessHolder.this.refClass("androidx.preference.Preference.OnPreferenceClickListener");
            this.ANDROIDX_PREFERENCE_CHANGE_LISTENER = ProcessHolder.this.refClass("androidx.preference.Preference.OnPreferenceChangeListener");
            this.ANDROIDX_VIEW_PAGER = ProcessHolder.this.refClass("androidx.viewpager.widget.ViewPager");
            this.ANDROIDX_PAGE_CHANGE_LISTENER = ProcessHolder.this.refClass("androidx.viewpager.widget.ViewPager.OnPageChangeListener");
            this.ANDROIDX_VIEW_DATA_BINDING = ProcessHolder.this.refClass("androidx.databinding.ViewDataBinding");
            this.ANDROIDX_DATA_BINDING_UTIL = ProcessHolder.this.refClass("androidx.databinding.DataBindingUtil");
            this.CLIENT_CONNECTION_MANAGER = ProcessHolder.this.refClass("org.apache.http.conn.ClientConnectionManager");
            this.DEFAULT_HTTP_CLIENT = ProcessHolder.this.refClass("org.apache.http.impl.client.DefaultHttpClient");
            this.SSL_SOCKET_FACTORY = ProcessHolder.this.refClass("org.apache.http.conn.ssl.SSLSocketFactory");
            this.PLAIN_SOCKET_FACTORY = ProcessHolder.this.refClass("org.apache.http.conn.scheme.PlainSocketFactory");
            this.SCHEME = ProcessHolder.this.refClass("org.apache.http.conn.scheme.Scheme");
            this.SCHEME_REGISTRY = ProcessHolder.this.refClass("org.apache.http.conn.scheme.SchemeRegistry");
            this.SINGLE_CLIENT_CONN_MANAGER = ProcessHolder.this.refClass("org.apache.http.impl.conn.SingleClientConnManager");
        }
    }
}

