/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.process;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.internal.model.AnnotationElements;
import org.androidannotations.internal.model.AnnotationElementsHolder;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;

public class ModelValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelValidator.class);
    private AndroidAnnotationsEnvironment environment;

    public ModelValidator(AndroidAnnotationsEnvironment environment) {
        this.environment = environment;
    }

    public AnnotationElements validate(AnnotationElements extractedModel, AnnotationElementsHolder validatingHolder) {
        LOGGER.info("Validating elements", new Object[0]);
        for (AnnotationHandler<?> annotationHandler : this.environment.getHandlers()) {
            if (!annotationHandler.isEnabled()) continue;
            String validatorSimpleName = annotationHandler.getClass().getSimpleName();
            String annotationName = annotationHandler.getTarget();
            Set<? extends Element> annotatedElements = extractedModel.getRootAnnotatedElements(annotationName);
            LinkedHashSet<Element> validatedAnnotatedElements = new LinkedHashSet<Element>();
            validatingHolder.putRootAnnotatedElements(annotationName, validatedAnnotatedElements);
            if (!annotatedElements.isEmpty()) {
                LOGGER.debug("Validating with {}: {}", validatorSimpleName, annotatedElements);
            }
            for (Element element : annotatedElements) {
                ElementValidation elementValidation = annotationHandler.validate(element);
                AnnotationMirror annotationMirror = elementValidation.getAnnotationMirror();
                for (ElementValidation.Error error : elementValidation.getErrors()) {
                    LOGGER.error(error.getElement(), annotationMirror, error.getMessage());
                }
                for (String warning : elementValidation.getWarnings()) {
                    LOGGER.warn(elementValidation.getElement(), annotationMirror, warning);
                }
                if (elementValidation.isValid()) {
                    validatedAnnotatedElements.add(element);
                    continue;
                }
                LOGGER.warn(element, "Element {} invalidated by {}", element, validatorSimpleName);
            }
        }
        return validatingHolder;
    }
}

