/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.process;

import com.helger.jcodemodel.JCodeModel;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.handler.GeneratingAnnotationHandler;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.internal.InternalAndroidAnnotationsEnvironment;
import org.androidannotations.internal.exception.ProcessingException;
import org.androidannotations.internal.model.AnnotationElements;
import org.androidannotations.internal.process.OriginatingElements;
import org.androidannotations.internal.process.ProcessHolder;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;

public class ModelProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelProcessor.class);
    private final InternalAndroidAnnotationsEnvironment environment;

    public ModelProcessor(InternalAndroidAnnotationsEnvironment environment) {
        this.environment = environment;
    }

    public ProcessResult process(AnnotationElements validatedModel) throws Exception {
        ProcessHolder processHolder = new ProcessHolder(this.environment.getProcessingEnvironment());
        this.environment.setProcessHolder(processHolder);
        LOGGER.info("Processing root elements", new Object[0]);
        while (this.generateElements(validatedModel, processHolder)) {
        }
        LOGGER.info("Processing enclosed elements", new Object[0]);
        for (AnnotationHandler<?> annotationHandler : this.environment.getDecoratingHandlers()) {
            if (!annotationHandler.isEnabled()) continue;
            String annotationName = annotationHandler.getTarget();
            Set<AnnotationElements.AnnotatedAndRootElements> ancestorAnnotatedElements = validatedModel.getAncestorAnnotatedElements(annotationName);
            if (!ancestorAnnotatedElements.isEmpty()) {
                LOGGER.debug("Processing enclosed elements with {}: {}", annotationHandler.getClass().getSimpleName(), ancestorAnnotatedElements);
            }
            for (AnnotationElements.AnnotatedAndRootElements elements : ancestorAnnotatedElements) {
                GeneratedClassHolder generatedClassHolder = processHolder.getGeneratedClassHolder(elements.rootTypeElement);
                if (generatedClassHolder == null) continue;
                this.processThrowing(annotationHandler, elements.annotatedElement, generatedClassHolder);
            }
            Set<? extends Element> rootAnnotatedElements = validatedModel.getRootAnnotatedElements(annotationName);
            for (Element element : rootAnnotatedElements) {
                Element enclosingElement;
                if (element instanceof TypeElement) {
                    enclosingElement = element;
                } else {
                    enclosingElement = element.getEnclosingElement();
                    if (enclosingElement instanceof ExecutableElement) {
                        enclosingElement = enclosingElement.getEnclosingElement();
                    }
                }
                if (!this.isAbstractClass(enclosingElement)) {
                    GeneratedClassHolder holder = processHolder.getGeneratedClassHolder(enclosingElement);
                    if (holder == null) continue;
                    this.processThrowing(annotationHandler, element, holder);
                    continue;
                }
                LOGGER.trace("Skip element {} because enclosing element {} is abstract", element, enclosingElement);
            }
        }
        return new ProcessResult(processHolder.codeModel(), processHolder.getOriginatingElements());
    }

    private <T extends GeneratedClassHolder> void processThrowing(AnnotationHandler<T> handler, Element element, T generatedClassHolder) throws ProcessingException {
        try {
            handler.process(element, generatedClassHolder);
        }
        catch (Exception e) {
            throw new ProcessingException(e, element);
        }
    }

    private boolean isAbstractClass(Element annotatedElement) {
        if (annotatedElement instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)annotatedElement;
            return typeElement.getKind() == ElementKind.CLASS && typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
        }
        return false;
    }

    private boolean generateElements(AnnotationElements validatedModel, ProcessHolder processHolder) throws Exception {
        boolean isElementRemaining = false;
        Set<? extends Element> validatedElements = validatedModel.getAllElements();
        for (GeneratingAnnotationHandler<?> generatingAnnotationHandler : this.environment.getGeneratingHandlers()) {
            if (!generatingAnnotationHandler.isEnabled()) continue;
            String annotationName = generatingAnnotationHandler.getTarget();
            Set<? extends Element> annotatedElements = validatedModel.getRootAnnotatedElements(annotationName);
            if (!annotatedElements.isEmpty()) {
                LOGGER.debug("Processing root elements {}: {}", generatingAnnotationHandler.getClass().getSimpleName(), annotatedElements);
            }
            for (Element element : annotatedElements) {
                if (!this.isAbstractClass(element)) {
                    if (processHolder.getGeneratedClassHolder(element) != null) continue;
                    TypeElement typeElement = (TypeElement)element;
                    Element enclosingElement = element.getEnclosingElement();
                    if (typeElement.getNestingKind() == NestingKind.MEMBER && processHolder.getGeneratedClassHolder(enclosingElement) == null) {
                        if (validatedElements.contains(enclosingElement)) {
                            isElementRemaining = true;
                            continue;
                        }
                        LOGGER.error(element, "Enclosing element {} has not been successfully validated", enclosingElement);
                        continue;
                    }
                    Object generatedClassHolder = generatingAnnotationHandler.createGeneratedClassHolder(this.environment, typeElement);
                    processHolder.put(element, (GeneratedClassHolder)generatedClassHolder);
                    generatingAnnotationHandler.process(element, generatedClassHolder);
                    continue;
                }
                LOGGER.trace("Skip element {} because it's abstract", element);
            }
        }
        return isElementRemaining;
    }

    public static class ProcessResult {
        public final JCodeModel codeModel;
        public final OriginatingElements originatingElements;

        public ProcessResult(JCodeModel codeModel, OriginatingElements originatingElements) {
            this.codeModel = codeModel;
            this.originatingElements = originatingElements;
        }
    }
}

