/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.internal.model.AnnotationElements;

public class AnnotationElementsHolder
implements AnnotationElements {
    private final Map<String, Set<? extends Element>> rootAnnotatedElementsByAnnotation = new HashMap<String, Set<? extends Element>>();
    private final Map<String, Set<AnnotationElements.AnnotatedAndRootElements>> ancestorAnnotatedElementsByAnnotation = new HashMap<String, Set<AnnotationElements.AnnotatedAndRootElements>>();

    public void putRootAnnotatedElements(String annotationName, Set<? extends Element> annotatedElements) {
        this.rootAnnotatedElementsByAnnotation.put(annotationName, annotatedElements);
    }

    public void putAncestorAnnotatedElement(String annotationName, Element annotatedElement, TypeElement rootTypeElement) {
        Set<AnnotationElements.AnnotatedAndRootElements> set = this.ancestorAnnotatedElementsByAnnotation.get(annotationName);
        if (set == null) {
            set = new LinkedHashSet<AnnotationElements.AnnotatedAndRootElements>();
            this.ancestorAnnotatedElementsByAnnotation.put(annotationName, set);
        }
        set.add(new AnnotationElements.AnnotatedAndRootElements(annotatedElement, rootTypeElement));
    }

    @Override
    public Set<AnnotationElements.AnnotatedAndRootElements> getAncestorAnnotatedElements(String annotationName) {
        Set<AnnotationElements.AnnotatedAndRootElements> set = this.ancestorAnnotatedElementsByAnnotation.get(annotationName);
        if (set != null) {
            return set;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<? extends Element> getRootAnnotatedElements(String annotationName) {
        Set<? extends Element> set = this.rootAnnotatedElementsByAnnotation.get(annotationName);
        if (set != null) {
            return set;
        }
        return Collections.emptySet();
    }

    public Set<Element> getAllElements() {
        HashSet<Element> allElements = new HashSet<Element>();
        for (Set<? extends Element> annotatedElements : this.rootAnnotatedElementsByAnnotation.values()) {
            allElements.addAll(annotatedElements);
        }
        return allElements;
    }

    public AnnotationElementsHolder validatingHolder() {
        AnnotationElementsHolder holder = new AnnotationElementsHolder();
        holder.ancestorAnnotatedElementsByAnnotation.putAll(this.ancestorAnnotatedElementsByAnnotation);
        return holder;
    }
}

