/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.helper;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDirectClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.api.view.HasViews;
import org.androidannotations.api.view.OnViewChangedNotifier;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.EViewHolder;

public class ViewNotifierHelper {
    private AndroidAnnotationsEnvironment environment;
    private EComponentWithViewSupportHolder holder;
    private JFieldVar notifier;

    public ViewNotifierHelper(EComponentWithViewSupportHolder holder, AndroidAnnotationsEnvironment environment) {
        this.holder = holder;
        this.environment = environment;
    }

    public void invokeViewChanged(JBlock block) {
        block.invoke((IJExpression)this.notifier, "notifyViewChanged").arg((IJExpression)JExpr._this());
    }

    public JVar replacePreviousNotifier(JBlock block) {
        AbstractJClass notifierClass = this.holder.getEnvironment().getJClass(OnViewChangedNotifier.class);
        if (this.notifier == null) {
            this.notifier = this.holder.getGeneratedClass().field(12, (AbstractJType)notifierClass, "onViewChangedNotifier" + ModelConstants.generationSuffix(), (IJExpression)JExpr._new((AbstractJClass)notifierClass));
            this.implementHasViewsInHolder();
        }
        return block.decl((AbstractJType)notifierClass, "previousNotifier", (IJExpression)notifierClass.staticInvoke("replaceNotifier").arg((IJExpression)this.notifier));
    }

    private void implementHasViewsInHolder() {
        this.holder.getGeneratedClass()._implements(HasViews.class);
        JCodeModel codeModel = this.environment.getCodeModel();
        JDirectClass genericType = codeModel.directClass("T");
        JMethod findViewById = this.holder.getGeneratedClass().method(1, (AbstractJType)genericType, "internalFindViewById");
        findViewById.generify("T", this.environment.getClasses().VIEW);
        findViewById.annotate(Override.class);
        JVar idParam = findViewById.param((AbstractJType)codeModel.INT, "id");
        IJExpression findViewByIdExpression = this.holder.getFindViewByIdExpression(idParam);
        findViewById.body()._return((IJExpression)JExpr.cast((AbstractJType)genericType, (IJExpression)findViewByIdExpression));
    }

    public JVar replacePreviousNotifierWithNull(JBlock block) {
        AbstractJClass notifierClass = this.holder.getEnvironment().getJClass(OnViewChangedNotifier.class);
        return block.decl((AbstractJType)notifierClass, "previousNotifier", (IJExpression)notifierClass.staticInvoke("replaceNotifier").arg((IJExpression)JExpr._null()));
    }

    public void resetPreviousNotifier(JBlock block, JVar previousNotifier) {
        AbstractJClass notifierClass = this.holder.getEnvironment().getJClass(OnViewChangedNotifier.class);
        block.staticInvoke(notifierClass, "replaceNotifier").arg((IJExpression)previousNotifier);
    }

    public void wrapInitWithNotifier() {
        JBlock initBlock = this.holder.getInit().body();
        JVar previousNotifier = this.replacePreviousNotifier(initBlock);
        ((EViewHolder)this.holder).setInitBody(this.holder.getInit().body().blockSimple());
        this.resetPreviousNotifier(initBlock.blockSimple(), previousNotifier);
    }
}

