/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public final class FileHelper {
    private FileHelper() {
    }

    public static File findRootProject(ProcessingEnvironment processingEnv) throws FileNotFoundException {
        FileHolder rootProjectHolder = FileHelper.findRootProjectHolder(processingEnv);
        return rootProjectHolder.projectRoot;
    }

    public static FileHolder findRootProjectHolder(ProcessingEnvironment processingEnv) throws FileNotFoundException {
        URI cleanURI;
        FileObject dummySourceFile;
        Filer filer = processingEnv.getFiler();
        try {
            dummySourceFile = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "dummy" + System.currentTimeMillis(), new Element[0]);
        }
        catch (IOException ignored) {
            throw new FileNotFoundException();
        }
        String dummySourceFilePath = dummySourceFile.toUri().toString();
        if (dummySourceFilePath.startsWith("file:")) {
            if (!dummySourceFilePath.startsWith("file://")) {
                dummySourceFilePath = "file://" + dummySourceFilePath.substring("file:".length());
            }
        } else {
            dummySourceFilePath = "file://" + dummySourceFilePath;
        }
        try {
            cleanURI = new URI(dummySourceFilePath);
        }
        catch (URISyntaxException e) {
            throw new FileNotFoundException();
        }
        File dummyFile = new File(cleanURI);
        File sourcesGenerationFolder = dummyFile.getParentFile();
        File projectRoot = sourcesGenerationFolder.getParentFile();
        return new FileHolder(dummySourceFilePath, sourcesGenerationFolder, projectRoot);
    }

    public static File resolveOutputDirectory(ProcessingEnvironment processingEnv) throws FileNotFoundException {
        File rootProject = FileHelper.findRootProject(processingEnv);
        File targetFolder = new File(rootProject, "target");
        if (targetFolder.isDirectory() && targetFolder.canWrite()) {
            return targetFolder;
        }
        File buildFolder = new File(rootProject, "build");
        if (buildFolder.isDirectory() && buildFolder.canWrite()) {
            return buildFolder;
        }
        File binFolder = new File(rootProject, "bin");
        if (binFolder.isDirectory() && binFolder.canWrite()) {
            return binFolder;
        }
        return rootProject;
    }

    static class FileHolder {
        String dummySourceFilePath;
        File sourcesGenerationFolder;
        File projectRoot;

        FileHolder(String dummySourceFilePath, File sourcesGenerationFolder, File projectRoot) {
            this.dummySourceFilePath = dummySourceFilePath;
            this.sourcesGenerationFolder = sourcesGenerationFolder;
            this.projectRoot = projectRoot;
        }
    }
}

