/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.helper;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JAnnotationArrayMember;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JEnumConstantRef;
import com.helger.jcodemodel.JExpr;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.internal.helper.AnnotationArrayParamExtractor;

public class AnnotationParamExtractor
extends SimpleAnnotationValueVisitor6<Void, String> {
    private JAnnotationUse use;
    private APTCodeModelHelper helper;

    public AnnotationParamExtractor(JAnnotationUse use, APTCodeModelHelper helper) {
        this.use = use;
        this.helper = helper;
    }

    @Override
    public Void visitArray(List<? extends AnnotationValue> vals, String p) {
        JAnnotationArrayMember paramArray = this.use.paramArray(p);
        for (AnnotationValue annotationValue : vals) {
            annotationValue.accept(new AnnotationArrayParamExtractor(this.helper), paramArray);
        }
        return null;
    }

    @Override
    public Void visitBoolean(boolean b, String p) {
        this.use.param(p, b);
        return null;
    }

    @Override
    public Void visitByte(byte b, String p) {
        this.use.param(p, b);
        return null;
    }

    @Override
    public Void visitChar(char c, String p) {
        this.use.param(p, c);
        return null;
    }

    @Override
    public Void visitDouble(double d, String p) {
        this.use.param(p, d);
        return null;
    }

    @Override
    public Void visitFloat(float f, String p) {
        this.use.param(p, f);
        return null;
    }

    @Override
    public Void visitInt(int i, String p) {
        this.use.param(p, i);
        return null;
    }

    @Override
    public Void visitLong(long i, String p) {
        this.use.param(p, i);
        return null;
    }

    @Override
    public Void visitShort(short s, String p) {
        this.use.param(p, s);
        return null;
    }

    @Override
    public Void visitString(String s, String p) {
        this.use.param(p, s);
        return null;
    }

    @Override
    public Void visitEnumConstant(VariableElement c, String p) {
        AbstractJClass annotationClass = this.helper.typeMirrorToJClass(c.asType());
        JEnumConstantRef ref = JExpr.enumConstantRef((AbstractJClass)annotationClass, (String)c.getSimpleName().toString());
        this.use.param(p, (IJExpression)ref);
        return null;
    }

    @Override
    public Void visitType(TypeMirror t, String p) {
        AbstractJClass annotationClass = this.helper.typeMirrorToJClass(t);
        this.use.param(p, (AbstractJType)annotationClass);
        return null;
    }

    @Override
    public Void visitAnnotation(AnnotationMirror a, String p) {
        AbstractJClass annotationJClass = this.helper.typeMirrorToJClass(a.getAnnotationType());
        this.use.annotationParam(p, annotationJClass);
        return null;
    }
}

