/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.helper;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JAnnotationArrayMember;
import com.helger.jcodemodel.JEnumConstantRef;
import com.helger.jcodemodel.JExpr;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import org.androidannotations.helper.APTCodeModelHelper;

public class AnnotationArrayParamExtractor
extends SimpleAnnotationValueVisitor6<Void, JAnnotationArrayMember> {
    private APTCodeModelHelper helper;

    public AnnotationArrayParamExtractor(APTCodeModelHelper helper) {
        this.helper = helper;
    }

    @Override
    public Void visitBoolean(boolean b, JAnnotationArrayMember p) {
        p.param(b);
        return null;
    }

    @Override
    public Void visitByte(byte b, JAnnotationArrayMember p) {
        p.param(b);
        return null;
    }

    @Override
    public Void visitChar(char c, JAnnotationArrayMember p) {
        p.param(c);
        return null;
    }

    @Override
    public Void visitDouble(double d, JAnnotationArrayMember p) {
        p.param(d);
        return null;
    }

    @Override
    public Void visitFloat(float f, JAnnotationArrayMember p) {
        p.param(f);
        return null;
    }

    @Override
    public Void visitInt(int i, JAnnotationArrayMember p) {
        p.param(i);
        return null;
    }

    @Override
    public Void visitLong(long i, JAnnotationArrayMember p) {
        p.param(i);
        return null;
    }

    @Override
    public Void visitShort(short s, JAnnotationArrayMember p) {
        p.param(s);
        return null;
    }

    @Override
    public Void visitString(String s, JAnnotationArrayMember p) {
        p.param(s);
        return null;
    }

    @Override
    public Void visitType(TypeMirror t, JAnnotationArrayMember p) {
        AbstractJClass annotationClass = this.helper.typeMirrorToJClass(t);
        p.param((AbstractJType)annotationClass);
        return null;
    }

    @Override
    public Void visitEnumConstant(VariableElement c, JAnnotationArrayMember p) {
        AbstractJClass annotationClass = this.helper.typeMirrorToJClass(c.asType());
        JEnumConstantRef ref = JExpr.enumConstantRef((AbstractJClass)annotationClass, (String)c.getSimpleName().toString());
        p.param((IJExpression)ref);
        return null;
    }

    @Override
    public Void visitAnnotation(AnnotationMirror a, JAnnotationArrayMember p) {
        this.helper.copyAnnotation((IJAnnotatable)p, a);
        return null;
    }
}

