/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.util.Elements;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.Option;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.internal.exception.AndroidManifestNotFoundException;
import org.androidannotations.internal.helper.FileHelper;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidManifestFinder {
    public static final Option OPTION_MANIFEST = new Option("androidManifestFile", null);
    public static final Option OPTION_LIBRARY = new Option("library", "false");
    private static final Logger LOGGER = LoggerFactory.getLogger(AndroidManifestFinder.class);
    private final AndroidAnnotationsEnvironment environment;

    public AndroidManifestFinder(AndroidAnnotationsEnvironment environment) {
        this.environment = environment;
    }

    public AndroidManifest extractAndroidManifest() throws AndroidManifestNotFoundException {
        try {
            File androidManifestFile = this.findManifestFile();
            String projectDirectory = androidManifestFile.getParent();
            boolean libraryOption = this.environment.getOptionBooleanValue(OPTION_LIBRARY);
            if (libraryOption) {
                return this.parse(androidManifestFile, true);
            }
            File projectProperties = new File(projectDirectory, "project.properties");
            boolean libraryProject = false;
            if (projectProperties.exists()) {
                Properties properties = new Properties();
                try {
                    properties.load(new FileInputStream(projectProperties));
                    if (properties.containsKey("android.library")) {
                        String androidLibraryProperty = properties.getProperty("android.library");
                        libraryProject = androidLibraryProperty.equals("true");
                        LOGGER.debug("Found android.library={} property in project.properties", libraryProject);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.parse(androidManifestFile, libraryProject);
        }
        catch (FileNotFoundException exception) {
            throw new AndroidManifestNotFoundException("Unable to find AndroidManifest.xml", exception);
        }
    }

    private File findManifestFile() throws FileNotFoundException {
        String androidManifestFile = this.environment.getOptionValue(OPTION_MANIFEST);
        if (androidManifestFile != null) {
            return this.findManifestInSpecifiedPath(androidManifestFile);
        }
        return this.findManifestInKnownPaths();
    }

    private File findManifestInSpecifiedPath(String androidManifestPath) throws FileNotFoundException {
        File androidManifestFile = new File(androidManifestPath);
        if (!androidManifestFile.exists()) {
            LOGGER.error("Could not find the AndroidManifest.xml file in specified path : {}", androidManifestPath);
            throw new FileNotFoundException();
        }
        LOGGER.debug("AndroidManifest.xml file found with specified path: {}", androidManifestFile.toString());
        return androidManifestFile;
    }

    private File findManifestInKnownPaths() throws FileNotFoundException {
        FileHelper.FileHolder holder = FileHelper.findRootProjectHolder(this.environment.getProcessingEnvironment());
        return this.findManifestInKnownPathsStartingFromGenFolder(holder.sourcesGenerationFolder.getAbsolutePath());
    }

    File findManifestInKnownPathsStartingFromGenFolder(String sourcesGenerationFolder) throws FileNotFoundException {
        List<AndroidManifestFinderStrategy> strategies = Arrays.asList(new GradleAndroidManifestFinderStrategy(sourcesGenerationFolder), new MavenAndroidManifestFinderStrategy(sourcesGenerationFolder), new EclipseAndroidManifestFinderStrategy(sourcesGenerationFolder));
        AndroidManifestFinderStrategy applyingStrategy = null;
        for (AndroidManifestFinderStrategy strategy : strategies) {
            if (!strategy.applies()) continue;
            applyingStrategy = strategy;
            break;
        }
        File androidManifestFile = null;
        if (applyingStrategy != null) {
            androidManifestFile = applyingStrategy.findAndroidManifestFile();
        }
        if (androidManifestFile != null) {
            LOGGER.debug("{} AndroidManifest.xml file found using generation folder {}: {}", applyingStrategy.name, sourcesGenerationFolder, androidManifestFile.toString());
        } else {
            LOGGER.error("Could not find the AndroidManifest.xml file, using  generation folder [{}])", sourcesGenerationFolder);
        }
        return androidManifestFile;
    }

    private AndroidManifest parse(File androidManifestFile, boolean libraryProject) throws AndroidManifestNotFoundException {
        Document doc;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(androidManifestFile);
        }
        catch (Exception e) {
            LOGGER.error("Could not parse the AndroidManifest.xml file at path {}", androidManifestFile, e);
            throw new AndroidManifestNotFoundException("Could not parse the AndroidManifest.xml file at path {}" + androidManifestFile, e);
        }
        Element documentElement = doc.getDocumentElement();
        documentElement.normalize();
        String applicationPackage = documentElement.getAttribute("package");
        int minSdkVersion = -1;
        int maxSdkVersion = -1;
        int targetSdkVersion = -1;
        NodeList sdkNodes = documentElement.getElementsByTagName("uses-sdk");
        if (sdkNodes.getLength() > 0) {
            Node sdkNode = sdkNodes.item(0);
            minSdkVersion = this.extractAttributeIntValue(sdkNode, "android:minSdkVersion", -1);
            maxSdkVersion = this.extractAttributeIntValue(sdkNode, "android:maxSdkVersion", -1);
            targetSdkVersion = this.extractAttributeIntValue(sdkNode, "android:targetSdkVersion", -1);
        }
        if (libraryProject) {
            return AndroidManifest.createLibraryManifest(applicationPackage, minSdkVersion, maxSdkVersion, targetSdkVersion);
        }
        NodeList applicationNodes = documentElement.getElementsByTagName("application");
        String applicationClassQualifiedName = null;
        boolean applicationDebuggableMode = false;
        if (applicationNodes.getLength() > 0) {
            Node debuggableAttribute;
            Node applicationNode = applicationNodes.item(0);
            Node nameAttribute = applicationNode.getAttributes().getNamedItem("android:name");
            applicationClassQualifiedName = this.manifestNameToValidQualifiedName(applicationPackage, nameAttribute);
            if (applicationClassQualifiedName == null && nameAttribute != null) {
                LOGGER.warn("The class application declared in the AndroidManifest.xml cannot be found in the compile path: [{}]", nameAttribute.getNodeValue());
            }
            if ((debuggableAttribute = applicationNode.getAttributes().getNamedItem("android:debuggable")) != null) {
                applicationDebuggableMode = debuggableAttribute.getNodeValue().equalsIgnoreCase("true");
            }
        }
        NodeList activityNodes = documentElement.getElementsByTagName("activity");
        List<String> activityQualifiedNames = this.extractComponentNames(applicationPackage, activityNodes);
        NodeList serviceNodes = documentElement.getElementsByTagName("service");
        List<String> serviceQualifiedNames = this.extractComponentNames(applicationPackage, serviceNodes);
        NodeList receiverNodes = documentElement.getElementsByTagName("receiver");
        List<String> receiverQualifiedNames = this.extractComponentNames(applicationPackage, receiverNodes);
        NodeList providerNodes = documentElement.getElementsByTagName("provider");
        List<String> providerQualifiedNames = this.extractComponentNames(applicationPackage, providerNodes);
        ArrayList<String> componentQualifiedNames = new ArrayList<String>();
        componentQualifiedNames.addAll(activityQualifiedNames);
        componentQualifiedNames.addAll(serviceQualifiedNames);
        componentQualifiedNames.addAll(receiverQualifiedNames);
        componentQualifiedNames.addAll(providerQualifiedNames);
        NodeList metaDataNodes = documentElement.getElementsByTagName("meta-data");
        Map<String, AndroidManifest.MetaDataInfo> metaDataQualifiedNames = this.extractMetaDataQualifiedNames(metaDataNodes);
        NodeList usesPermissionNodes = documentElement.getElementsByTagName("uses-permission");
        List<String> usesPermissionQualifiedNames = this.extractUsesPermissionNames(usesPermissionNodes);
        ArrayList<String> permissionQualifiedNames = new ArrayList<String>();
        permissionQualifiedNames.addAll(usesPermissionQualifiedNames);
        return AndroidManifest.createManifest(applicationPackage, applicationClassQualifiedName, componentQualifiedNames, metaDataQualifiedNames, permissionQualifiedNames, minSdkVersion, maxSdkVersion, targetSdkVersion, applicationDebuggableMode);
    }

    private int extractAttributeIntValue(Node node, String attribute, int defaultValue) {
        try {
            Node attributeNode;
            NamedNodeMap attributes = node.getAttributes();
            if (attributes.getLength() > 0 && (attributeNode = attributes.getNamedItem(attribute)) != null) {
                return Integer.parseInt(attributeNode.getNodeValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    private List<String> extractComponentNames(String applicationPackage, NodeList componentNodes) {
        ArrayList<String> componentQualifiedNames = new ArrayList<String>();
        for (int i = 0; i < componentNodes.getLength(); ++i) {
            Node activityNode = componentNodes.item(i);
            Node nameAttribute = activityNode.getAttributes().getNamedItem("android:name");
            String qualifiedName = this.manifestNameToValidQualifiedName(applicationPackage, nameAttribute);
            if (qualifiedName != null) {
                componentQualifiedNames.add(qualifiedName);
                continue;
            }
            if (nameAttribute != null) {
                LOGGER.warn("A class activity declared in the AndroidManifest.xml cannot be found in the compile path: [{}]", nameAttribute.getNodeValue());
                continue;
            }
            LOGGER.warn("The {} activity node in the AndroidManifest.xml has no android:name attribute", i);
        }
        return componentQualifiedNames;
    }

    private Map<String, AndroidManifest.MetaDataInfo> extractMetaDataQualifiedNames(NodeList metaDataNodes) {
        HashMap<String, AndroidManifest.MetaDataInfo> metaDataQualifiedNames = new HashMap<String, AndroidManifest.MetaDataInfo>();
        for (int i = 0; i < metaDataNodes.getLength(); ++i) {
            Node node = metaDataNodes.item(i);
            Node nameAttribute = node.getAttributes().getNamedItem("android:name");
            Node valueAttribute = node.getAttributes().getNamedItem("android:value");
            Node resourceAttribute = node.getAttributes().getNamedItem("android:resource");
            if (nameAttribute == null || valueAttribute == null && resourceAttribute == null) {
                if (nameAttribute != null) {
                    LOGGER.warn("A malformed <meta-data> has been found in the manifest with name {}", nameAttribute.getNodeValue());
                    continue;
                }
                LOGGER.warn("A malformed <meta-data> has been found in the manifest", new Object[0]);
                continue;
            }
            String name = nameAttribute.getNodeValue();
            String value = valueAttribute != null ? valueAttribute.getNodeValue() : null;
            String resource = resourceAttribute != null ? resourceAttribute.getNodeValue() : null;
            metaDataQualifiedNames.put(name, new AndroidManifest.MetaDataInfo(name, value, resource));
        }
        return metaDataQualifiedNames;
    }

    private String manifestNameToValidQualifiedName(String applicationPackage, Node nameAttribute) {
        if (nameAttribute != null) {
            String activityName = nameAttribute.getNodeValue();
            if (activityName.startsWith(applicationPackage)) {
                return this.returnClassIfExistsOrNull(activityName);
            }
            if (activityName.startsWith(".")) {
                return this.returnClassIfExistsOrNull(applicationPackage + activityName);
            }
            if (this.classOrModelClassExists(activityName)) {
                return activityName;
            }
            return this.returnClassIfExistsOrNull(applicationPackage + "." + activityName);
        }
        return null;
    }

    private boolean classOrModelClassExists(String className) {
        Elements elementUtils = this.environment.getProcessingEnvironment().getElementUtils();
        if (className.endsWith(ModelConstants.classSuffix())) {
            className = className.substring(0, className.length() - ModelConstants.classSuffix().length());
        }
        return elementUtils.getTypeElement(className) != null;
    }

    private String returnClassIfExistsOrNull(String className) {
        if (this.classOrModelClassExists(className)) {
            return className;
        }
        return null;
    }

    private List<String> extractUsesPermissionNames(NodeList usesPermissionNodes) {
        ArrayList<String> usesPermissionQualifiedNames = new ArrayList<String>();
        for (int i = 0; i < usesPermissionNodes.getLength(); ++i) {
            Node usesPermissionNode = usesPermissionNodes.item(i);
            Node nameAttribute = usesPermissionNode.getAttributes().getNamedItem("android:name");
            if (nameAttribute == null) {
                return null;
            }
            usesPermissionQualifiedNames.add(nameAttribute.getNodeValue());
        }
        return usesPermissionQualifiedNames;
    }

    private static class EclipseAndroidManifestFinderStrategy
    extends AndroidManifestFinderStrategy {
        static final Pattern ECLIPSE_GEN_FOLDER = Pattern.compile("^(.*?)\\.apt_generated.*$");

        EclipseAndroidManifestFinderStrategy(String sourceFolder) {
            super("Eclipse", ECLIPSE_GEN_FOLDER, sourceFolder);
        }

        @Override
        Iterable<String> possibleLocations() {
            return Collections.singleton("");
        }
    }

    private static class MavenAndroidManifestFinderStrategy
    extends AndroidManifestFinderStrategy {
        static final Pattern MAVEN_GEN_FOLDER = Pattern.compile("^(.*?)target[\\\\/]generated-sources.*$");

        MavenAndroidManifestFinderStrategy(String sourceFolder) {
            super("Maven", MAVEN_GEN_FOLDER, sourceFolder);
        }

        @Override
        Iterable<String> possibleLocations() {
            return Arrays.asList("target", "src/main", "");
        }
    }

    private static class GradleAndroidManifestFinderStrategy
    extends AndroidManifestFinderStrategy {
        static final Pattern GRADLE_GEN_FOLDER = Pattern.compile("^(.*?)build[\\\\/]generated[\\\\/]source[\\\\/](k?apt)(.*)$");
        private static final List<String> SUPPORTED_ABI_SPLITS = Arrays.asList("arm64-v8a", "armeabi", "armeabi-v7a", "mips", "mips64", "x86", "x86_64");
        private static final List<String> SUPPORTED_DENSITY_SPLITS = Arrays.asList("hdpi", "ldpi", "mdpi", "xhdpi", "xxhdpi", "xxxhdpi");
        private static final String BUILD_TOOLS_V32_MANIFEST_PATH = "build/intermediates/merged_manifests";

        GradleAndroidManifestFinderStrategy(String sourceFolder) {
            super("Gradle", GRADLE_GEN_FOLDER, sourceFolder);
        }

        @Override
        Iterable<String> possibleLocations() {
            String path = this.matcher.group(1);
            String mode = this.matcher.group(2);
            String gradleVariant = this.matcher.group(3);
            String variantPart = gradleVariant.substring(1);
            ArrayList<String> possibleLocations = new ArrayList<String>();
            this.findPossibleLocationsV32(path, variantPart, possibleLocations);
            for (String directory : Arrays.asList("build/intermediates/manifests/full", "build/intermediates/bundles", "build/intermediates/manifests/aapt")) {
                this.findPossibleLocations(path, directory, variantPart, possibleLocations);
            }
            return possibleLocations;
        }

        private void findPossibleLocationsV32(String basePath, String variantPart, List<String> possibleLocations) {
            String[] variantParts;
            String[] directories = new File(basePath + BUILD_TOOLS_V32_MANIFEST_PATH).list();
            if (directories == null) {
                return;
            }
            if (variantPart.startsWith("/") || variantPart.startsWith("\\")) {
                variantPart = variantPart.substring(1);
            }
            if ((variantParts = variantPart.split("[/\\\\]")).length > 1) {
                StringBuilder sb = new StringBuilder(variantParts[0]);
                for (int i = 1; i < variantParts.length; ++i) {
                    String part = variantParts[i];
                    sb.append(CaseHelper.upperCaseFirst(part));
                }
                variantPart = sb.toString();
            }
            String processManifest = "process" + CaseHelper.upperCaseFirst(variantPart) + "Manifest";
            String possibleLocation = "build/intermediates/merged_manifests/" + variantPart + "/" + processManifest + "/merged";
            File variantDir = new File(basePath + possibleLocation);
            if (variantDir.isDirectory()) {
                possibleLocations.add(possibleLocation);
                this.addPossibleSplitLocations(basePath, possibleLocation, possibleLocations);
            }
        }

        private void findPossibleLocations(String basePath, String targetPath, String variantPart, List<String> possibleLocations) {
            String[] directories = new File(basePath + targetPath).list();
            if (directories == null) {
                return;
            }
            if (variantPart.startsWith("/") || variantPart.startsWith("\\")) {
                variantPart = variantPart.substring(1);
            }
            for (String directory : directories) {
                String possibleLocation = targetPath + "/" + directory;
                File variantDir = new File(basePath + possibleLocation);
                if (!variantDir.isDirectory() || !variantPart.toLowerCase().startsWith(directory.toLowerCase())) continue;
                String remainingPart = variantPart.substring(directory.length());
                if (remainingPart.length() == 0) {
                    possibleLocations.add(possibleLocation);
                    this.addPossibleSplitLocations(basePath, possibleLocation, possibleLocations);
                    continue;
                }
                this.findPossibleLocations(basePath, possibleLocation, remainingPart, possibleLocations);
            }
        }

        private void addPossibleSplitLocations(String basePath, String possibleLocation, List<String> possibleLocations) {
            File splitDir;
            for (String abiSplit : SUPPORTED_ABI_SPLITS) {
                splitDir = new File(basePath + possibleLocation + "/" + abiSplit);
                if (!splitDir.isDirectory()) continue;
                possibleLocations.add(possibleLocation + "/" + abiSplit);
                for (String densitySplit : SUPPORTED_DENSITY_SPLITS) {
                    File splitSubDir = new File(basePath + possibleLocation + "/" + abiSplit + "/" + densitySplit);
                    if (!splitSubDir.isDirectory()) continue;
                    possibleLocations.add(possibleLocation + "/" + abiSplit + "/" + densitySplit);
                }
            }
            for (String densitySplit : SUPPORTED_DENSITY_SPLITS) {
                splitDir = new File(basePath + possibleLocation + "/" + densitySplit);
                if (!splitDir.isDirectory()) continue;
                possibleLocations.add(possibleLocation + "/" + densitySplit);
            }
        }
    }

    private static abstract class AndroidManifestFinderStrategy {
        final String name;
        final Matcher matcher;

        AndroidManifestFinderStrategy(String name, Pattern sourceFolderPattern, String sourceFolder) {
            this.name = name;
            this.matcher = sourceFolderPattern.matcher(sourceFolder);
        }

        File findAndroidManifestFile() {
            for (String location : this.possibleLocations()) {
                File manifestFile = new File(this.matcher.group(1), location + "/AndroidManifest.xml");
                if (!manifestFile.exists()) continue;
                return manifestFile;
            }
            return null;
        }

        boolean applies() {
            return this.matcher.matches();
        }

        abstract Iterable<String> possibleLocations();
    }
}

