/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.generation;

import com.helger.jcodemodel.AbstractCodeWriter;
import com.helger.jcodemodel.JPackage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import org.androidannotations.internal.process.OriginatingElements;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;

public class SourceCodeWriter
extends AbstractCodeWriter {
    private static final VoidOutputStream VOID_OUTPUT_STREAM = new VoidOutputStream();
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceCodeWriter.class);
    private final Filer filer;
    private OriginatingElements originatingElements;

    public SourceCodeWriter(Filer filer, OriginatingElements originatingElements, Charset charset) {
        super(charset, SourceCodeWriter.getDefaultNewLine());
        this.filer = filer;
        this.originatingElements = originatingElements;
    }

    public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
        String qualifiedClassName = this.toQualifiedClassName(pkg, fileName);
        LOGGER.debug("Generating class: {}", qualifiedClassName);
        Element[] classOriginatingElements = this.originatingElements.getClassOriginatingElements(qualifiedClassName);
        try {
            if (classOriginatingElements.length == 0) {
                LOGGER.info("Generating class with no originating element: {}", qualifiedClassName);
            }
            JavaFileObject sourceFile = this.filer.createSourceFile(qualifiedClassName, classOriginatingElements);
            return sourceFile.openOutputStream();
        }
        catch (FilerException e) {
            LOGGER.error("Could not generate source file for {} due to error: {}", qualifiedClassName, e.getMessage());
            return VOID_OUTPUT_STREAM;
        }
    }

    private String toQualifiedClassName(JPackage pkg, String fileName) {
        int suffixPosition = fileName.lastIndexOf(46);
        String className = fileName.substring(0, suffixPosition);
        String qualifiedClassName = pkg.name() + "." + className;
        return qualifiedClassName;
    }

    public void close() throws IOException {
    }

    private static class VoidOutputStream
    extends OutputStream {
        private VoidOutputStream() {
        }

        @Override
        public void write(int arg0) throws IOException {
        }
    }
}

