/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.generation;

import com.helger.jcodemodel.AbstractCodeWriter;
import com.helger.jcodemodel.writer.PrologCodeWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import javax.annotation.processing.Filer;
import org.androidannotations.Option;
import org.androidannotations.internal.generation.ResourceCodeWriter;
import org.androidannotations.internal.generation.SourceCodeWriter;
import org.androidannotations.internal.process.ModelProcessor;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;

public class CodeModelGenerator {
    public static final Option OPTION_ENCODING = new Option("encoding", "UTF-8");
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeModelGenerator.class);
    private final Filer filer;
    private final String header;
    private final String encoding;

    public CodeModelGenerator(Filer filer, String aaVersion, String encoding) {
        this.filer = filer;
        this.header = "DO NOT EDIT THIS FILE.\nGenerated using AndroidAnnotations " + aaVersion + ".\n\nYou can create a larger work that contains this file and distribute that work under terms of your choice.\n";
        this.encoding = encoding;
    }

    public void generate(ModelProcessor.ProcessResult processResult) throws IOException {
        Charset charset = this.getCharset();
        SourceCodeWriter sourceCodeWriter = new SourceCodeWriter(this.filer, processResult.originatingElements, charset);
        PrologCodeWriter prologCodeWriter = new PrologCodeWriter((AbstractCodeWriter)sourceCodeWriter, this.header);
        processResult.codeModel.build((AbstractCodeWriter)prologCodeWriter, (AbstractCodeWriter)new ResourceCodeWriter(this.filer, charset));
    }

    private Charset getCharset() {
        try {
            return Charset.forName(this.encoding);
        }
        catch (UnsupportedCharsetException exception) {
            Charset defaultCharset = Charset.defaultCharset();
            LOGGER.warn("The requested charset ({}) is not available, falling back to platform default ({}).", this.encoding, defaultCharset);
            return defaultCharset;
        }
    }
}

