/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.model;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import org.androidannotations.annotations.res.AnimationRes;
import org.androidannotations.annotations.res.BooleanRes;
import org.androidannotations.annotations.res.ColorRes;
import org.androidannotations.annotations.res.ColorStateListRes;
import org.androidannotations.annotations.res.DimensionPixelOffsetRes;
import org.androidannotations.annotations.res.DimensionPixelSizeRes;
import org.androidannotations.annotations.res.DimensionRes;
import org.androidannotations.annotations.res.DrawableRes;
import org.androidannotations.annotations.res.HtmlRes;
import org.androidannotations.annotations.res.IntArrayRes;
import org.androidannotations.annotations.res.IntegerRes;
import org.androidannotations.annotations.res.LayoutRes;
import org.androidannotations.annotations.res.MovieRes;
import org.androidannotations.annotations.res.StringArrayRes;
import org.androidannotations.annotations.res.StringRes;
import org.androidannotations.annotations.res.TextArrayRes;
import org.androidannotations.annotations.res.TextRes;
import org.androidannotations.rclass.IRClass;

public enum AndroidRes {
    STRING(IRClass.Res.STRING, StringRes.class, "getString", "java.lang.String"),
    STRING_ARRAY(IRClass.Res.ARRAY, StringArrayRes.class, "getStringArray", "java.lang.String[]"),
    ANIMATION(IRClass.Res.ANIM, AnimationRes.class, "getAnimation", "android.content.res.XmlResourceParser", "android.view.animation.Animation"),
    HTML(IRClass.Res.STRING, HtmlRes.class, "getString", "java.lang.CharSequence", "android.text.Spanned"),
    BOOLEAN(IRClass.Res.BOOL, BooleanRes.class, "getBoolean", "java.lang.Boolean", "boolean"),
    COLOR_STATE_LIST(IRClass.Res.COLOR, ColorStateListRes.class, "getColorStateList", "android.content.res.ColorStateList"),
    DIMENSION(IRClass.Res.DIMEN, DimensionRes.class, "getDimension", "java.lang.Float", "float"),
    DIMENSION_PIXEL_OFFSET(IRClass.Res.DIMEN, DimensionPixelOffsetRes.class, "getDimensionPixelOffset", "java.lang.Integer", "int"),
    DIMENSION_PIXEL_SIZE(IRClass.Res.DIMEN, DimensionPixelSizeRes.class, "getDimensionPixelSize", "java.lang.Integer", "int"),
    DRAWABLE(IRClass.Res.DRAWABLE, DrawableRes.class, "getDrawable", "android.graphics.drawable.Drawable"),
    INT_ARRAY(IRClass.Res.ARRAY, IntArrayRes.class, "getIntArray", "int[]"),
    INTEGER(IRClass.Res.INTEGER, IntegerRes.class, "getInteger", "java.lang.Integer", "int"),
    LAYOUT(IRClass.Res.LAYOUT, LayoutRes.class, "getLayout", "android.content.res.XmlResourceParser"),
    MOVIE(IRClass.Res.MOVIE, MovieRes.class, "getMovie", "android.graphics.Movie"),
    TEXT(IRClass.Res.STRING, TextRes.class, "getText", "java.lang.CharSequence"),
    TEXT_ARRAY(IRClass.Res.ARRAY, TextArrayRes.class, "getTextArray", "java.lang.CharSequence"),
    COLOR(IRClass.Res.COLOR, ColorRes.class, "getColor", "int", "java.lang.Integer");

    private final Class<? extends Annotation> annotationClass;
    private final String resourceMethodName;
    private final List<String> allowedTypes;
    private final IRClass.Res rInnerClass;

    private AndroidRes(IRClass.Res rInnerClass, Class<? extends Annotation> annotationClass, String resourceMethodName, String ... allowedTypes) {
        this.annotationClass = annotationClass;
        this.resourceMethodName = resourceMethodName;
        this.allowedTypes = Arrays.asList(allowedTypes);
        this.rInnerClass = rInnerClass;
    }

    public IRClass.Res getRInnerClass() {
        return this.rInnerClass;
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public String getTarget() {
        return this.annotationClass.getName();
    }

    public String getResourceMethodName() {
        return this.resourceMethodName;
    }

    public List<String> getAllowedTypes() {
        return this.allowedTypes;
    }
}

