/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.helper;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.helper.ParcelerHelper;
import org.androidannotations.holder.HasIntentBuilder;
import org.androidannotations.internal.process.ProcessHolder;

public abstract class IntentBuilder {
    protected AndroidAnnotationsEnvironment environment;
    protected HasIntentBuilder holder;
    protected AndroidManifest androidManifest;
    protected JDefinedClass builderClass;
    protected JFieldRef contextField;
    protected JFieldRef intentField;
    protected AbstractJClass contextClass;
    protected AbstractJClass intentClass;
    protected Elements elementUtils;
    protected Types typeUtils;
    protected APTCodeModelHelper codeModelHelper;
    protected AnnotationHelper annotationHelper;
    protected ParcelerHelper parcelerHelper;

    public IntentBuilder(HasIntentBuilder holder, AndroidManifest androidManifest) {
        this.environment = holder.getEnvironment();
        this.holder = holder;
        this.androidManifest = androidManifest;
        this.annotationHelper = new AnnotationHelper(this.environment);
        this.parcelerHelper = new ParcelerHelper(this.environment);
        this.codeModelHelper = new APTCodeModelHelper(this.environment);
        this.elementUtils = this.environment.getProcessingEnvironment().getElementUtils();
        this.typeUtils = this.environment.getProcessingEnvironment().getTypeUtils();
        this.contextClass = this.environment.getClasses().CONTEXT;
        this.intentClass = this.environment.getClasses().INTENT;
    }

    public void build() throws JClassAlreadyExistsException {
        this.createClass();
        this.createContextConstructor();
        this.createIntentMethod();
    }

    private void createClass() throws JClassAlreadyExistsException {
        this.builderClass = (JDefinedClass)this.holder.getGeneratedClass()._class(17, "IntentBuilder" + ModelConstants.generationSuffix());
        this.builderClass._extends(this.getSuperClass());
        this.holder.setIntentBuilderClass(this.builderClass);
        this.contextField = JExpr.ref((String)"context");
        this.intentField = JExpr.ref((String)"intent");
    }

    private void createContextConstructor() {
        IJExpression generatedClass = this.holder.getGeneratedClass().dotclass();
        JMethod constructor = this.holder.getIntentBuilderClass().constructor(1);
        JVar constructorContextParam = constructor.param((AbstractJType)this.getClasses().CONTEXT, "context");
        constructor.body().invoke("super").arg((IJExpression)constructorContextParam).arg(generatedClass);
    }

    private void createIntentMethod() {
        JMethod method = this.holder.getGeneratedClass().method(17, (AbstractJType)this.holder.getIntentBuilderClass(), "intent");
        JVar contextParam = method.param((AbstractJType)this.contextClass, "context");
        method.body()._return((IJExpression)JExpr._new((AbstractJClass)this.holder.getIntentBuilderClass()).arg((IJExpression)contextParam));
    }

    public JMethod getPutExtraMethod(Element element, IntentExtra intentExtra) {
        return this.addPutExtraMethod(element, Collections.singletonList(intentExtra));
    }

    public JMethod getPutExtraMethod(Element element, List<IntentExtra> intentExtra) {
        return this.addPutExtraMethod(element, intentExtra);
    }

    private JMethod addPutExtraMethod(Element element, List<IntentExtra> intentExtras) {
        String docComment = this.elementUtils.getDocComment(element);
        JMethod method = this.holder.getIntentBuilderClass().method(1, (AbstractJType)this.holder.getIntentBuilderClass(), element.getSimpleName().toString());
        method.javadoc().addReturn().append((Object)"the IntentBuilder to chain calls");
        this.codeModelHelper.addTrimmedDocComment(method, docComment);
        int paramCount = intentExtras.size();
        for (int i = 0; i < paramCount; ++i) {
            IntentExtra intentExtra = intentExtras.get(i);
            method.javadoc().addParam(intentExtra.parameterName).append((Object)"the value for this extra");
            AbstractJClass parameterClass = this.codeModelHelper.typeMirrorToJClass(intentExtra.type);
            JVar extraParameterVar = method.param((AbstractJType)parameterClass, intentExtra.parameterName);
            JInvocation superCall = this.getSuperPutExtraInvocation(intentExtra.type, extraParameterVar, intentExtra.keyField);
            if (i + 1 == paramCount) {
                method.body()._return((IJExpression)superCall);
                continue;
            }
            method.body().add((IJStatement)superCall);
        }
        return method;
    }

    public JInvocation getSuperPutExtraInvocation(TypeMirror elementType, JVar extraParam, JFieldVar extraKeyField) {
        JVar extraParameterArg = extraParam;
        if (elementType.getKind() == TypeKind.DECLARED) {
            Elements elementUtils = this.environment.getProcessingEnvironment().getElementUtils();
            TypeMirror parcelableType = elementUtils.getTypeElement("android.os.Parcelable").asType();
            if (this.typeUtils.isSubtype(elementType, parcelableType)) {
                TypeMirror serializableType = elementUtils.getTypeElement(CanonicalNameConstants.SERIALIZABLE).asType();
                if (this.typeUtils.isSubtype(elementType, serializableType)) {
                    extraParameterArg = JExpr.cast((AbstractJType)this.environment.getClasses().PARCELABLE, (IJExpression)extraParameterArg);
                }
            } else if (!BundleHelper.METHOD_SUFFIX_BY_TYPE_NAME.containsKey(elementType.toString()) && this.parcelerHelper.isParcelType(elementType)) {
                extraParameterArg = this.environment.getJClass("org.parceler.Parcels").staticInvoke("wrap").arg((IJExpression)extraParameterArg);
            } else {
                TypeMirror stringType = elementUtils.getTypeElement(CanonicalNameConstants.STRING).asType();
                if (!this.typeUtils.isSubtype(elementType, stringType)) {
                    extraParameterArg = JExpr.cast((AbstractJType)this.environment.getClasses().SERIALIZABLE, (IJExpression)extraParameterArg);
                }
            }
        }
        return JExpr._super().invoke("extra").arg((IJExpression)extraKeyField).arg((IJExpression)extraParameterArg);
    }

    protected abstract AbstractJClass getSuperClass();

    protected ProcessHolder.Classes getClasses() {
        return this.environment.getClasses();
    }

    protected AbstractJClass getJClass(Class<?> clazz) {
        return this.environment.getJClass(clazz);
    }

    public static class IntentExtra {
        private final TypeMirror type;
        private final String parameterName;
        private final JFieldVar keyField;

        public IntentExtra(TypeMirror type, String parameterName, JFieldVar keyField) {
            this.type = type;
            this.parameterName = parameterName;
            this.keyField = keyField;
        }

        public TypeMirror getType() {
            return this.type;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public JFieldVar getKeyField() {
            return this.keyField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntentExtra that = (IntentExtra)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.parameterName, that.parameterName) && Objects.equals(this.keyField, that.keyField);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.parameterName, this.keyField);
        }
    }
}

