/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.helper;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.androidannotations.api.builder.PostActivityStarter;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.HasIntentBuilder;
import org.androidannotations.internal.core.helper.IntentBuilder;

public class ActivityIntentBuilder
extends IntentBuilder {
    private static final int MIN_SDK_WITH_FRAGMENT_SUPPORT = 11;
    private static final int MIN_SDK_WITH_ACTIVITY_OPTIONS = 16;
    private JFieldVar fragmentField;
    private JFieldVar fragmentSupportField;
    private JFieldRef optionsField;

    public ActivityIntentBuilder(HasIntentBuilder holder, AndroidManifest androidManifest) {
        super(holder, androidManifest);
    }

    @Override
    public void build() throws JClassAlreadyExistsException {
        super.build();
        this.optionsField = JExpr.ref((String)"lastOptions");
        this.createAdditionalConstructor();
        this.createAdditionalIntentMethods();
        this.overrideStartForResultMethod();
    }

    private void createAdditionalIntentMethods() {
        JVar fragmentParam;
        JMethod method;
        if (this.hasFragmentInClasspath()) {
            method = this.holder.getGeneratedClass().method(17, (AbstractJType)this.holder.getIntentBuilderClass(), "intent");
            fragmentParam = method.param((AbstractJType)this.getClasses().FRAGMENT, "fragment");
            method.body()._return((IJExpression)JExpr._new((AbstractJClass)this.holder.getIntentBuilderClass()).arg((IJExpression)fragmentParam));
        }
        if (this.hasAndroidxFragmentInClasspath()) {
            method = this.holder.getGeneratedClass().method(17, (AbstractJType)this.holder.getIntentBuilderClass(), "intent");
            fragmentParam = method.param((AbstractJType)this.getClasses().ANDROIDX_FRAGMENT, "supportFragment");
            method.body()._return((IJExpression)JExpr._new((AbstractJClass)this.holder.getIntentBuilderClass()).arg((IJExpression)fragmentParam));
        } else if (this.hasFragmentSupportInClasspath()) {
            method = this.holder.getGeneratedClass().method(17, (AbstractJType)this.holder.getIntentBuilderClass(), "intent");
            fragmentParam = method.param((AbstractJType)this.getClasses().SUPPORT_V4_FRAGMENT, "supportFragment");
            method.body()._return((IJExpression)JExpr._new((AbstractJClass)this.holder.getIntentBuilderClass()).arg((IJExpression)fragmentParam));
        }
    }

    @Override
    protected AbstractJClass getSuperClass() {
        AbstractJClass superClass = this.environment.getJClass(org.androidannotations.api.builder.ActivityIntentBuilder.class);
        return superClass.narrow((AbstractJClass)this.builderClass);
    }

    private void createAdditionalConstructor() {
        if (this.hasFragmentInClasspath()) {
            this.fragmentField = this.addFragmentConstructor(this.getClasses().FRAGMENT, "fragment" + ModelConstants.generationSuffix());
        }
        if (this.hasAndroidxFragmentInClasspath()) {
            this.fragmentSupportField = this.addFragmentConstructor(this.getClasses().ANDROIDX_FRAGMENT, "fragmentSupport" + ModelConstants.generationSuffix());
        } else if (this.hasFragmentSupportInClasspath()) {
            this.fragmentSupportField = this.addFragmentConstructor(this.getClasses().SUPPORT_V4_FRAGMENT, "fragmentSupport" + ModelConstants.generationSuffix());
        }
    }

    private JFieldVar addFragmentConstructor(AbstractJClass fragmentClass, String fieldName) {
        JFieldVar fragmentField = this.holder.getIntentBuilderClass().field(4, (AbstractJType)fragmentClass, fieldName);
        IJExpression generatedClass = this.holder.getGeneratedClass().dotclass();
        JMethod constructor = this.holder.getIntentBuilderClass().constructor(1);
        JVar constructorFragmentParam = constructor.param((AbstractJType)fragmentClass, "fragment");
        JBlock constructorBody = constructor.body();
        constructorBody.invoke("super").arg((IJExpression)constructorFragmentParam.invoke("getActivity")).arg(generatedClass);
        constructorBody.assign((IJAssignmentTarget)fragmentField, (IJExpression)constructorFragmentParam);
        return fragmentField;
    }

    private void overrideStartForResultMethod() {
        AbstractJClass postActivityStarterClass = this.environment.getJClass(PostActivityStarter.class);
        JMethod method = this.holder.getIntentBuilderClass().method(1, (AbstractJType)postActivityStarterClass, "startForResult");
        method.annotate(Override.class);
        JVar requestCode = method.param((AbstractJType)this.environment.getCodeModel().INT, "requestCode");
        JBlock body = method.body();
        JConditional condition = null;
        if (this.fragmentSupportField != null) {
            condition = body._if(this.fragmentSupportField.ne((IJExpression)JExpr._null()));
            condition._then().invoke((IJExpression)this.fragmentSupportField, "startActivityForResult").arg((IJExpression)this.intentField).arg((IJExpression)requestCode);
        }
        if (this.fragmentField != null) {
            condition = condition == null ? body._if(this.fragmentField.ne((IJExpression)JExpr._null())) : condition._elseif(this.fragmentField.ne((IJExpression)JExpr._null()));
            JBlock fragmentStartForResultInvocationBlock = this.hasActivityOptionsInFragment() && this.shouldGuardActivityOptions() ? this.createCallWithIfGuard(requestCode, condition._then(), (IJExpression)this.fragmentField) : condition._then();
            JInvocation invocation = fragmentStartForResultInvocationBlock.invoke((IJExpression)this.fragmentField, "startActivityForResult").arg((IJExpression)this.intentField).arg((IJExpression)requestCode);
            if (this.hasActivityOptionsInFragment()) {
                invocation.arg((IJExpression)this.optionsField);
            }
        }
        JBlock activityStartInvocationBlock = null;
        activityStartInvocationBlock = condition != null ? condition._else() : method.body();
        JConditional activityCondition = activityStartInvocationBlock._if(this.contextField._instanceof((AbstractJType)this.getClasses().ACTIVITY));
        JBlock thenBlock = activityCondition._then();
        JVar activityVar = thenBlock.decl((AbstractJType)this.getClasses().ACTIVITY, "activity", (IJExpression)JExpr.cast((AbstractJType)this.getClasses().ACTIVITY, (IJExpression)this.contextField));
        AbstractJClass activityCompat = this.getActivityCompat();
        if (activityCompat != null) {
            thenBlock.staticInvoke(activityCompat, "startActivityForResult").arg((IJExpression)activityVar).arg((IJExpression)this.intentField).arg((IJExpression)requestCode).arg((IJExpression)this.optionsField);
        } else if (this.hasActivityOptionsInFragment()) {
            JBlock startForResultInvocationBlock = this.shouldGuardActivityOptions() ? this.createCallWithIfGuard(requestCode, thenBlock, (IJExpression)activityVar) : thenBlock;
            startForResultInvocationBlock.invoke((IJExpression)activityVar, "startActivityForResult").arg((IJExpression)this.intentField).arg((IJExpression)requestCode).arg((IJExpression)this.optionsField);
        } else {
            thenBlock.invoke((IJExpression)activityVar, "startActivityForResult").arg((IJExpression)this.intentField).arg((IJExpression)requestCode);
        }
        if (this.hasActivityOptionsInFragment()) {
            JBlock startInvocationBlock = this.shouldGuardActivityOptions() ? this.createCallWithIfGuard(null, activityCondition._else(), (IJExpression)this.contextField) : activityCondition._else();
            startInvocationBlock.invoke((IJExpression)this.contextField, "startActivity").arg((IJExpression)this.intentField).arg((IJExpression)this.optionsField);
        } else {
            activityCondition._else().invoke((IJExpression)this.contextField, "startActivity").arg((IJExpression)this.intentField);
        }
        body._return((IJExpression)JExpr._new((AbstractJClass)postActivityStarterClass).arg((IJExpression)this.contextField));
    }

    private JBlock createCallWithIfGuard(JVar requestCode, JBlock thenBlock, IJExpression invocationTarget) {
        JConditional guardIf = thenBlock._if(this.getClasses().BUILD_VERSION.staticRef("SDK_INT").gte((IJExpression)this.getClasses().BUILD_VERSION_CODES.staticRef("JELLY_BEAN")));
        JBlock startInvocationBlock = guardIf._then();
        String methodName = requestCode != null ? "startActivityForResult" : "startActivity";
        JInvocation invocation = guardIf._else().invoke(invocationTarget, methodName).arg((IJExpression)this.intentField);
        if (requestCode != null) {
            invocation.arg((IJExpression)requestCode);
        }
        return startInvocationBlock;
    }

    protected boolean hasFragmentInClasspath() {
        boolean fragmentExistsInSdk = this.androidManifest.getMinSdkVersion() >= 11;
        return fragmentExistsInSdk && this.elementUtils.getTypeElement("android.app.Fragment") != null;
    }

    protected boolean hasFragmentSupportInClasspath() {
        return this.elementUtils.getTypeElement("android.support.v4.app.Fragment") != null;
    }

    protected boolean hasAndroidxFragmentInClasspath() {
        return this.elementUtils.getTypeElement("androidx.fragment.app.Fragment") != null;
    }

    protected boolean hasActivityOptionsInFragment() {
        if (!this.hasFragmentInClasspath()) {
            return false;
        }
        TypeElement fragment = this.elementUtils.getTypeElement("android.app.Fragment");
        return this.hasActivityOptions(fragment, 1);
    }

    private AbstractJClass getActivityCompat() {
        TypeElement androidxActivityCompat = this.elementUtils.getTypeElement("androidx.core.app.ActivityCompat");
        if (this.hasActivityOptions(androidxActivityCompat, 2)) {
            return this.getClasses().ANDROIDX_ACTIVITY_COMPAT;
        }
        TypeElement activityCompat = this.elementUtils.getTypeElement("android.support.v4.app.ActivityCompat");
        if (this.hasActivityOptions(activityCompat, 2)) {
            return this.getClasses().ACTIVITY_COMPAT;
        }
        return null;
    }

    private boolean hasActivityOptions(TypeElement type, int optionsParamPosition) {
        if (type == null) {
            return false;
        }
        for (ExecutableElement element : ElementFilter.methodsIn(this.elementUtils.getAllMembers(type))) {
            VariableElement parameter;
            List<? extends VariableElement> parameters;
            if (!element.getSimpleName().contentEquals("startActivity") || (parameters = element.getParameters()).size() != optionsParamPosition + 1 || !(parameter = parameters.get(optionsParamPosition)).asType().toString().equals("android.os.Bundle")) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldGuardActivityOptions() {
        return this.androidManifest.getMinSdkVersion() < 16;
    }
}

