/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JExpr;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.WindowFeature;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.holder.EActivityHolder;

public class WindowFeatureHandler
extends BaseAnnotationHandler<EActivityHolder> {
    public WindowFeatureHandler(AndroidAnnotationsEnvironment environment) {
        super(WindowFeature.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.hasEActivity(element, validation);
    }

    @Override
    public void process(Element element, EActivityHolder holder) throws Exception {
        WindowFeature annotation = element.getAnnotation(WindowFeature.class);
        int[] features = annotation.value();
        TypeElement appCompatActivity = this.annotationHelper.typeElementFromQualifiedName("android.support.v7.app.AppCompatActivity");
        TypeElement androidxAppCompatActivity = this.annotationHelper.typeElementFromQualifiedName("androidx.appcompat.app.AppCompatActivity");
        TypeElement actionBarActivity = this.annotationHelper.typeElementFromQualifiedName("android.support.v7.app.ActionBarActivity");
        TypeElement type = (TypeElement)element;
        String methodName = appCompatActivity != null && this.annotationHelper.isSubtype(type, appCompatActivity) || androidxAppCompatActivity != null && this.annotationHelper.isSubtype(type, androidxAppCompatActivity) || actionBarActivity != null && this.annotationHelper.isSubtype(type, actionBarActivity) ? "supportRequestWindowFeature" : "requestWindowFeature";
        for (int feature : features) {
            holder.getInitBodyInjectionBlock().invoke(methodName).arg((IJExpression)JExpr.lit((int)feature));
        }
    }
}

