/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JTryBlock;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.WakeLock;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.internal.core.handler.CoreBaseAnnotationHandler;

public class WakeLockHandler
extends CoreBaseAnnotationHandler<EComponentHolder> {
    public WakeLockHandler(AndroidAnnotationsEnvironment environment) {
        super(WakeLock.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.coreValidatorHelper.doesNotHaveTraceAnnotationAndReturnValue(executableElement, valid);
        this.coreValidatorHelper.doesNotUseFlagsWithPartialWakeLock(element, valid);
        this.validatorHelper.hasWakeLockPermission(this.getEnvironment().getAndroidManifest(), valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.isNotFinal(element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        ExecutableElement executableElement = (ExecutableElement)element;
        WakeLock annotation = executableElement.getAnnotation(WakeLock.class);
        String tag = this.extractTag(executableElement);
        WakeLock.Level level = annotation.level();
        WakeLock.Flag[] flags = annotation.flags();
        JMethod method = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        JBlock previousMethodBody = this.codeModelHelper.removeBody(method);
        JBlock methodBody = method.body();
        JFieldRef levelAndFlags = this.getClasses().POWER_MANAGER.staticRef(level.name());
        if (flags.length > 0) {
            for (WakeLock.Flag flag : flags) {
                levelAndFlags = levelAndFlags.bor((IJExpression)this.getClasses().POWER_MANAGER.staticRef(flag.name()));
            }
        }
        JInvocation newWakeLock = holder.getPowerManagerRef().invoke("newWakeLock").arg((IJExpression)levelAndFlags).arg((IJExpression)JExpr.lit((String)tag));
        JVar wakeLock = methodBody.decl((AbstractJType)this.getClasses().WAKE_LOCK, "wakeLock", (IJExpression)JExpr._null());
        JTryBlock tryBlock = methodBody._try();
        tryBlock.body().assign((IJAssignmentTarget)wakeLock, (IJExpression)newWakeLock);
        tryBlock.body().add((IJStatement)wakeLock.invoke("acquire"));
        tryBlock.body().add((IJStatement)previousMethodBody);
        JBlock finallyBlock = tryBlock._finally();
        JConditional ifStatement = finallyBlock._if(wakeLock.ne((IJExpression)JExpr._null()));
        ifStatement._then().add((IJStatement)wakeLock.invoke("release"));
    }

    private String extractTag(Element element) {
        WakeLock annotation = element.getAnnotation(WakeLock.class);
        String tag = annotation.tag();
        if ("NO_TAG".equals(tag)) {
            tag = element.getEnclosingElement().getSimpleName().toString() + "." + element.getSimpleName().toString();
        }
        return tag;
    }
}

