/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.ViewsById;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.FoundViewHolder;
import org.androidannotations.rclass.IRClass;

public class ViewsByIdHandler
extends BaseAnnotationHandler<EComponentWithViewSupportHolder>
implements MethodInjectionHandler<EComponentWithViewSupportHolder> {
    private final InjectHelper<EComponentWithViewSupportHolder> injectHelper;

    public ViewsByIdHandler(AndroidAnnotationsEnvironment environment) {
        super(ViewsById.class, environment);
        this.injectHelper = new InjectHelper<EComponentWithViewSupportHolder>(this.validatorHelper, this);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(ViewsById.class, element, validation);
        if (!validation.isValid()) {
            return;
        }
        Element param = this.injectHelper.getParam(element);
        this.validatorHelper.isDeclaredType(param, validation);
        this.validatorHelper.extendsListOfView(param, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.NEED_RES_ID, validation);
        this.validatorHelper.isNotPrivate(element, validation);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(EComponentWithViewSupportHolder holder) {
        return holder.getOnViewChangedBodyInjectionBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EComponentWithViewSupportHolder holder, Element element, Element param) {
        TypeMirror viewType = this.extractViewClass(param);
        AbstractJClass viewClass = this.codeModelHelper.typeMirrorToJClass(viewType);
        String listName = this.getListName(element, param);
        IJExpression arrayList = this.instantiateArrayList(viewType, holder, "list_" + listName);
        List<JFieldRef> idsRefs = this.annotationHelper.extractAnnotationFieldRefs(element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            this.addViewToListIfNotNull(arrayList, viewClass, idRef, holder);
        }
        targetBlock.add((IJStatement)fieldRef.assign(arrayList));
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, valid);
    }

    private String getListName(Element element, Element param) {
        String listName = param.getSimpleName().toString();
        if (element.getKind() == ElementKind.PARAMETER) {
            listName = element.getEnclosingElement().getSimpleName().toString() + "_" + listName;
        } else if (element.getKind() == ElementKind.METHOD) {
            listName = element.getSimpleName().toString() + "_" + listName;
        }
        return listName;
    }

    private IJExpression instantiateArrayList(TypeMirror viewType, EComponentWithViewSupportHolder holder, String name) {
        TypeElement arrayListTypeElement = this.annotationHelper.typeElementFromQualifiedName(CanonicalNameConstants.ARRAYLIST);
        DeclaredType arrayListType = this.getProcessingEnvironment().getTypeUtils().getDeclaredType(arrayListTypeElement, viewType);
        AbstractJClass arrayListClass = this.codeModelHelper.typeMirrorToJClass(arrayListType);
        return holder.getOnViewChangedBodyBeforeInjectionBlock().decl((AbstractJType)arrayListClass, name, (IJExpression)JExpr._new((AbstractJClass)arrayListClass));
    }

    private TypeMirror extractViewClass(Element element) {
        DeclaredType elementType = (DeclaredType)element.asType();
        List<? extends TypeMirror> elementTypeArguments = elementType.getTypeArguments();
        TypeMirror viewType = this.annotationHelper.typeElementFromQualifiedName("android.view.View").asType();
        if (!elementTypeArguments.isEmpty()) {
            viewType = elementTypeArguments.get(0);
        }
        return viewType;
    }

    private void addViewToListIfNotNull(IJExpression elementRef, AbstractJClass viewClass, JFieldRef idRef, EComponentWithViewSupportHolder holder) {
        FoundViewHolder foundViewHolder = holder.getFoundViewHolder(idRef, viewClass);
        foundViewHolder.getIfNotNullBlock().invoke(elementRef, "add").arg(foundViewHolder.getOrCastRef(viewClass));
    }
}

