/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.ViewById;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.EFragmentHolder;
import org.androidannotations.holder.FoundViewHolder;
import org.androidannotations.rclass.IRClass;

public class ViewByIdHandler
extends BaseAnnotationHandler<EComponentWithViewSupportHolder>
implements MethodInjectionHandler<EComponentWithViewSupportHolder> {
    private final InjectHelper<EComponentWithViewSupportHolder> injectHelper;

    public ViewByIdHandler(AndroidAnnotationsEnvironment environment) {
        super(ViewById.class, environment);
        this.injectHelper = new InjectHelper<EComponentWithViewSupportHolder>(this.validatorHelper, this);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(ViewById.class, element, validation);
        if (!validation.isValid()) {
            return;
        }
        Element param = this.injectHelper.getParam(element);
        this.validatorHelper.isDeclaredType(param, validation);
        this.validatorHelper.extendsView(param, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, validation);
        this.validatorHelper.isNotPrivate(element, validation);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) {
        this.injectHelper.process(element, holder);
        if (holder instanceof EFragmentHolder && this.isFieldInjection(element)) {
            String fieldName = element.getSimpleName().toString();
            ((EFragmentHolder)holder).clearInjectedView((IJAssignmentTarget)JExpr.ref((String)fieldName));
        }
    }

    private boolean isFieldInjection(Element element) {
        Element enclosingElement = element.getEnclosingElement();
        return !(element instanceof ExecutableElement) && !(enclosingElement instanceof ExecutableElement);
    }

    @Override
    public JBlock getInvocationBlock(EComponentWithViewSupportHolder holder) {
        return holder.getOnViewChangedBodyInjectionBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EComponentWithViewSupportHolder holder, Element element, Element param) {
        FoundViewHolder viewHolder;
        TypeMirror uiFieldTypeMirror = param.asType();
        JFieldRef idRef = this.annotationHelper.extractOneAnnotationFieldRef(element, IRClass.Res.ID, true);
        AbstractJClass viewClass = this.codeModelHelper.typeMirrorToJClass(uiFieldTypeMirror);
        IJAssignmentTarget viewHolderTarget = null;
        if (element.getKind() == ElementKind.FIELD) {
            viewHolderTarget = fieldRef;
        }
        if (!(viewHolder = holder.getFoundViewHolder(idRef, viewClass, viewHolderTarget)).getRef().equals(viewHolderTarget)) {
            targetBlock.add((IJStatement)fieldRef.assign(viewHolder.getOrCastRef(viewClass)));
        }
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, valid);
    }
}

