/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JOp;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.UiThread;
import org.androidannotations.api.UiThreadExecutor;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.internal.core.handler.AbstractRunnableHandler;

public class UiThreadHandler
extends AbstractRunnableHandler {
    private static final String METHOD_CUR_THREAD = "currentThread";
    private static final String METHOD_MAIN_LOOPER = "getMainLooper";
    private static final String METHOD_GET_THREAD = "getThread";
    private static final String METHOD_RUN_TASK = "runTask";

    public UiThreadHandler(AndroidAnnotationsEnvironment environment) {
        super(UiThread.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation valid) {
        super.validate(element, valid);
        this.coreValidatorHelper.usesEnqueueIfHasId(element, valid);
        UiThread annotation = element.getAnnotation(UiThread.class);
        long delay = annotation.delay();
        UiThread.Propagation propagation = annotation.propagation();
        if (delay != 0L && propagation == UiThread.Propagation.REUSE) {
            valid.addWarning("propagation=REUSE is ignored when using a delay");
        }
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod delegatingMethod = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        JBlock previousBody = this.codeModelHelper.removeBody(delegatingMethod);
        JDefinedClass anonymousRunnableClass = this.codeModelHelper.createDelegatingAnonymousRunnableClass(previousBody);
        UiThread annotation = element.getAnnotation(UiThread.class);
        long delay = annotation.delay();
        UiThread.Propagation propagation = annotation.propagation();
        if (delay == 0L && propagation == UiThread.Propagation.REUSE) {
            this.addUIThreadCheck(delegatingMethod, previousBody, holder);
        }
        delegatingMethod.body().add((IJStatement)this.getJClass(UiThreadExecutor.class).staticInvoke(METHOD_RUN_TASK).arg(annotation.id()).arg((IJExpression)JExpr._new((AbstractJClass)anonymousRunnableClass)).arg((IJExpression)JExpr.lit((long)delay)));
    }

    private void addUIThreadCheck(JMethod delegatingMethod, JBlock previousBody, EComponentHolder holder) throws JClassAlreadyExistsException {
        AbstractJClass tClass = this.getClasses().THREAD;
        AbstractJClass lClass = this.getClasses().LOOPER;
        JInvocation lhs = tClass.staticInvoke(METHOD_CUR_THREAD);
        JInvocation rhs = lClass.staticInvoke(METHOD_MAIN_LOOPER).invoke(METHOD_GET_THREAD);
        JConditional con = delegatingMethod.body()._if((IJExpression)JOp.eq((IJExpression)lhs, (IJExpression)rhs));
        JBlock thenBlock = con._then().add((IJStatement)previousBody);
        thenBlock._return();
    }
}

