/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCatchBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JTryBlock;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.Transactional;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.LogHelper;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.EComponentHolder;

public class TransactionalHandler
extends BaseAnnotationHandler<EComponentHolder> {
    public TransactionalHandler(AndroidAnnotationsEnvironment environment) {
        super(Transactional.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.doesntThrowException(executableElement, validation);
        this.validatorHelper.isNotFinal(element, validation);
        ((ValidatorParameterHelper.InOrderParamValidator)((ValidatorParameterHelper.InOrderParamValidator)((ValidatorParameterHelper.InOrderParamValidator)((ValidatorParameterHelper.InOrderParamValidator)this.validatorHelper.param.inOrder().type("android.database.sqlite.SQLiteDatabase")).anyType()).multiple()).optional()).validate(executableElement, validation);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        ExecutableElement executableElement = (ExecutableElement)element;
        String returnTypeName = executableElement.getReturnType().toString();
        AbstractJClass returnType = this.getJClass(returnTypeName);
        JMethod method = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        this.codeModelHelper.removeBody(method);
        JVar db = (JVar)method.params().get(0);
        JBlock body = method.body();
        body.invoke((IJExpression)db, "beginTransaction");
        JTryBlock tryBlock = body._try();
        JFieldRef activitySuper = holder.getGeneratedClass().staticRef("super");
        JInvocation superCall = JExpr.invoke((IJExpression)activitySuper, (JMethod)method);
        for (JVar param : method.params()) {
            superCall.arg((IJExpression)param);
        }
        JBlock tryBody = tryBlock.body();
        if (returnTypeName.equals("void")) {
            tryBody.add((IJStatement)superCall);
            tryBody.invoke((IJExpression)db, "setTransactionSuccessful");
            tryBody._return();
        } else {
            JVar result = tryBody.decl((AbstractJType)returnType, "result_", (IJExpression)superCall);
            tryBody.invoke((IJExpression)db, "setTransactionSuccessful");
            tryBody._return((IJExpression)result);
        }
        JCatchBlock catchBlock = tryBlock._catch(this.getJClass(RuntimeException.class));
        JVar exceptionParam = catchBlock.param("e");
        JBlock catchBody = catchBlock.body();
        JInvocation errorInvoke = catchBody.staticInvoke(this.getClasses().LOG, "e");
        errorInvoke.arg(LogHelper.logTagForClassHolder(holder));
        errorInvoke.arg("Error in transaction");
        errorInvoke.arg((IJExpression)exceptionParam);
        catchBody._throw((IJExpression)exceptionParam);
        tryBlock._finally().invoke((IJExpression)db, "endTransaction");
    }
}

