/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JTryBlock;
import com.helger.jcodemodel.JVar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.Option;
import org.androidannotations.annotations.Trace;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.LogHelper;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EComponentHolder;

public class TraceHandler
extends BaseAnnotationHandler<EComponentHolder> {
    public static final Option OPTION_TRACE = new Option("trace", "false");

    public TraceHandler(AndroidAnnotationsEnvironment environment) {
        super(Trace.class, environment);
    }

    @Override
    public boolean isEnabled() {
        return this.getEnvironment().getOptionBooleanValue(OPTION_TRACE);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.hasValidLogLevel(element, validation);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        JTryBlock tryBlock;
        ExecutableElement executableElement = (ExecutableElement)element;
        String tag = this.extractTag(executableElement);
        int level = executableElement.getAnnotation(Trace.class).level();
        JMethod method = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        JBlock previousMethodBody = this.codeModelHelper.removeBody(method);
        JBlock methodBody = method.body();
        JInvocation isLoggableInvocation = this.getClasses().LOG.staticInvoke("isLoggable");
        isLoggableInvocation.arg(tag).arg((IJExpression)this.logLevelFromInt(level, this.getClasses().LOG));
        JConditional ifStatement = methodBody._if((IJExpression)isLoggableInvocation);
        JInvocation currentTimeInvoke = this.getClasses().SYSTEM.staticInvoke("currentTimeMillis");
        JBlock thenBody = ifStatement._then();
        String logMethodName = this.logMethodNameFromLevel(level);
        JInvocation logEnterInvoke = this.getClasses().LOG.staticInvoke(logMethodName);
        logEnterInvoke.arg(tag);
        logEnterInvoke.arg(this.getEnterMessage(method, executableElement));
        thenBody.add((IJStatement)logEnterInvoke);
        JVar startDeclaration = thenBody.decl((AbstractJType)this.getCodeModel().LONG, "traceStart" + ModelConstants.generationSuffix(), (IJExpression)currentTimeInvoke);
        JVar result = null;
        if (method.type().fullName().equals("void")) {
            tryBlock = thenBody._try();
            tryBlock.body().add((IJStatement)previousMethodBody);
        } else {
            JInvocation superCall = this.codeModelHelper.getSuperCall(holder, method);
            result = thenBody.decl((AbstractJType)this.getJClass(Object.class), "traceResult" + ModelConstants.generationSuffix(), (IJExpression)JExpr._null());
            tryBlock = thenBody._try();
            tryBlock.body().assign((IJAssignmentTarget)result, (IJExpression)superCall);
            tryBlock.body()._return((IJExpression)JExpr.cast((AbstractJType)this.boxify(method.type()), (IJExpression)result));
        }
        JBlock finallyBlock = tryBlock._finally();
        JVar durationDeclaration = finallyBlock.decl((AbstractJType)this.getCodeModel().LONG, "traceDuration" + ModelConstants.generationSuffix(), currentTimeInvoke.minus((IJExpression)startDeclaration));
        JInvocation logExitInvoke = this.getClasses().LOG.staticInvoke(logMethodName);
        logExitInvoke.arg(tag);
        logExitInvoke.arg(this.getExitMessage(executableElement, method, result, durationDeclaration));
        finallyBlock.add((IJStatement)logExitInvoke);
        JBlock elseBlock = ifStatement._else();
        elseBlock.add((IJStatement)previousMethodBody);
    }

    private AbstractJClass boxify(AbstractJType type) throws ClassNotFoundException {
        return this.getCodeModel().parseType(type.fullName()).boxify();
    }

    private IJExpression getExitMessage(ExecutableElement element, JMethod method, JVar result, JVar duration) throws ClassNotFoundException {
        String methodName = this.getMethodName(element);
        List params = method.params();
        StringBuilder paramStr = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            if (i > 0) {
                paramStr.append(", ");
            }
            JVar var = (JVar)params.get(i);
            paramStr.append(var.type().name());
        }
        methodName = methodName + "(" + paramStr.toString() + ")";
        JInvocation format = this.getJClass(String.class).staticInvoke("format");
        if (result == null) {
            format.arg("Exiting [" + methodName + "], duration in ms: %d");
        } else {
            format.arg("Exiting [" + methodName + " returning: %s], duration in ms: %d");
            if (method.type().isArray()) {
                AbstractJClass arraysClass = this.getJClass(Arrays.class);
                format.arg((IJExpression)arraysClass.staticInvoke("toString").arg((IJExpression)JExpr.cast((AbstractJType)this.boxify(method.type()), (IJExpression)result)));
            } else {
                format.arg((IJExpression)result);
            }
        }
        return format.arg((IJExpression)duration);
    }

    private IJExpression getEnterMessage(JMethod method, ExecutableElement element) {
        String methodName = this.getMethodName(element);
        List params = method.params();
        if (params.isEmpty()) {
            return JExpr.lit((String)("Entering [" + methodName + "()]"));
        }
        AbstractJClass arraysClass = this.getJClass(Arrays.class);
        StringBuilder paramStr = new StringBuilder();
        ArrayList<Object> paramExpressions = new ArrayList<Object>();
        for (int i = 0; i < params.size(); ++i) {
            if (i > 0) {
                paramStr.append(", ");
            }
            JVar var = (JVar)params.get(i);
            paramStr.append(var.name()).append(" = %s");
            if (var.type().isArray()) {
                paramExpressions.add(arraysClass.staticInvoke("toString").arg((IJExpression)var));
                continue;
            }
            paramExpressions.add(var);
        }
        JInvocation format = this.getJClass(String.class).staticInvoke("format");
        format.arg((IJExpression)JExpr.lit((String)("Entering [" + methodName + "(" + paramStr + ")]")));
        for (IJExpression iJExpression : paramExpressions) {
            format.arg(iJExpression);
        }
        return format;
    }

    private String getMethodName(ExecutableElement element) {
        String returnType = element.getReturnType().toString();
        String simpleName = element.getSimpleName().toString();
        return returnType + " " + simpleName;
    }

    private String logMethodNameFromLevel(int level) {
        switch (level) {
            case 3: {
                return "d";
            }
            case 2: {
                return "v";
            }
            case 4: {
                return "i";
            }
            case 5: {
                return "w";
            }
            case 6: {
                return "e";
            }
        }
        throw new IllegalArgumentException("Unrecognized Log level : " + level);
    }

    private JFieldRef logLevelFromInt(int level, AbstractJClass logClass) {
        switch (level) {
            case 3: {
                return logClass.staticRef("DEBUG");
            }
            case 2: {
                return logClass.staticRef("VERBOSE");
            }
            case 4: {
                return logClass.staticRef("INFO");
            }
            case 5: {
                return logClass.staticRef("WARN");
            }
            case 6: {
                return logClass.staticRef("ERROR");
            }
        }
        throw new IllegalArgumentException("Unrecognized log level. Given value:" + level);
    }

    private String extractTag(Element element) {
        Trace annotation = element.getAnnotation(Trace.class);
        String tag = annotation.tag();
        if ("NO_TAG".equals(tag)) {
            tag = element.getEnclosingElement().getSimpleName().toString();
        }
        return LogHelper.trimLogTag(tag);
    }
}

