/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.Touch;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.internal.core.handler.AbstractViewListenerHandler;

public class TouchHandler
extends AbstractViewListenerHandler {
    public TouchHandler(AndroidAnnotationsEnvironment environment) {
        super(Touch.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoidOrBoolean(executableElement, validation);
        ((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)((ValidatorParameterHelper.AnyOrderParamValidator)this.validatorHelper.param.anyOrder().type("android.view.MotionEvent")).optional()).extendsType("android.view.View")).optional()).validate(executableElement, validation);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        boolean returnMethodResult;
        boolean bl = returnMethodResult = returnType.getKind() != TypeKind.VOID;
        if (returnMethodResult) {
            listenerMethodBody._return((IJExpression)call);
        } else {
            listenerMethodBody.add((IJStatement)call);
            listenerMethodBody._return((IJExpression)JExpr.TRUE);
        }
    }

    @Override
    protected void processParameters(EComponentWithViewSupportHolder holder, JMethod listenerMethod, JInvocation call, List<? extends VariableElement> parameters) {
        JVar viewParam = listenerMethod.param((AbstractJType)this.getClasses().VIEW, "view");
        JVar eventParam = listenerMethod.param((AbstractJType)this.getClasses().MOTION_EVENT, "event");
        for (VariableElement variableElement : parameters) {
            String parameterType = variableElement.asType().toString();
            if (parameterType.equals("android.view.MotionEvent")) {
                call.arg((IJExpression)eventParam);
                continue;
            }
            if (!this.isTypeOrSubclass("android.view.View", variableElement)) continue;
            call.arg(this.castArgumentIfNecessary(holder, "android.view.View", viewParam, variableElement));
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, (AbstractJType)this.getCodeModel().BOOLEAN, "onTouch");
    }

    @Override
    protected String getSetterName() {
        return "setOnTouchListener";
    }

    @Override
    protected AbstractJClass getListenerClass(EComponentWithViewSupportHolder holder) {
        return this.getClasses().VIEW_ON_TOUCH_LISTENER;
    }
}

