/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.TextChange;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.TextWatcherHolder;
import org.androidannotations.internal.core.handler.CoreBaseAnnotationHandler;
import org.androidannotations.rclass.IRClass;

public class TextChangeHandler
extends CoreBaseAnnotationHandler<EComponentWithViewSupportHolder> {
    public TextChangeHandler(AndroidAnnotationsEnvironment environment) {
        super(TextChange.class, environment);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validation);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, validation);
        this.validatorHelper.isNotPrivate(element, validation);
        this.validatorHelper.doesntThrowException(element, validation);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, validation);
        this.coreValidatorHelper.hasTextChangedMethodParameters((ExecutableElement)element, validation);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int startParameterPosition = -1;
        int countParameterPosition = -1;
        int beforeParameterPosition = -1;
        int charSequenceParameterPosition = -1;
        int viewParameterPosition = -1;
        TypeMirror viewParameterType = null;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            String parameterName = parameter.toString();
            TypeMirror parameterType = parameter.asType();
            if (CanonicalNameConstants.CHAR_SEQUENCE.equals(parameterType.toString())) {
                charSequenceParameterPosition = i;
                continue;
            }
            if (parameterType.getKind() == TypeKind.INT || CanonicalNameConstants.INTEGER.equals(parameterType.toString())) {
                if ("start".equals(parameterName)) {
                    startParameterPosition = i;
                    continue;
                }
                if ("count".equals(parameterName)) {
                    countParameterPosition = i;
                    continue;
                }
                if (!"before".equals(parameterName)) continue;
                beforeParameterPosition = i;
                continue;
            }
            TypeMirror textViewType = this.annotationHelper.typeElementFromQualifiedName("android.widget.TextView").asType();
            if (!this.annotationHelper.isSubtype(parameterType, textViewType)) continue;
            viewParameterPosition = i;
            viewParameterType = parameterType;
        }
        List<JFieldRef> idsRefs = this.annotationHelper.extractAnnotationFieldRefs(element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            TextWatcherHolder textWatcherHolder = holder.getTextWatcherHolder(idRef, viewParameterType);
            JBlock methodBody = textWatcherHolder.getOnTextChangedBody();
            JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
            JInvocation textChangeCall = methodBody.invoke((IJExpression)activityRef, methodName);
            for (int i = 0; i < parameters.size(); ++i) {
                if (i == startParameterPosition) {
                    JVar startParameter = textWatcherHolder.getOnTextChangedStartParam();
                    textChangeCall.arg((IJExpression)startParameter);
                    continue;
                }
                if (i == countParameterPosition) {
                    JVar countParameter = textWatcherHolder.getOnTextChangedCountParam();
                    textChangeCall.arg((IJExpression)countParameter);
                    continue;
                }
                if (i == beforeParameterPosition) {
                    JVar beforeParameter = textWatcherHolder.getOnTextChangedBeforeParam();
                    textChangeCall.arg((IJExpression)beforeParameter);
                    continue;
                }
                if (i == charSequenceParameterPosition) {
                    JVar charSequenceParam = textWatcherHolder.getOnTextChangedCharSequenceParam();
                    textChangeCall.arg((IJExpression)charSequenceParam);
                    continue;
                }
                if (i != viewParameterPosition) continue;
                JVar viewParameter = textWatcherHolder.getTextViewVariable();
                textChangeCall.arg((IJExpression)viewParameter);
            }
        }
    }
}

