/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JOp;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.SystemService;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.internal.core.model.AndroidSystemServices;

public class SystemServiceHandler
extends BaseAnnotationHandler<EComponentHolder>
implements MethodInjectionHandler<EComponentHolder> {
    private final InjectHelper<EComponentHolder> injectHelper;

    public SystemServiceHandler(AndroidAnnotationsEnvironment environment) {
        super(SystemService.class, environment);
        this.injectHelper = new InjectHelper<EComponentHolder>(this.validatorHelper, this);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(SystemService.class, element, validation);
        if (!validation.isValid()) {
            return;
        }
        this.validatorHelper.androidService(element, validation);
        this.validatorHelper.isNotPrivate(element, validation);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        this.injectHelper.process(element, holder);
    }

    @Override
    public JBlock getInvocationBlock(EComponentHolder holder) {
        return holder.getInitBodyInjectionBlock();
    }

    @Override
    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EComponentHolder holder, Element element, Element param) {
        TypeMirror serviceType = param.asType();
        String fieldTypeQualifiedName = serviceType.toString();
        JFieldRef serviceRef = new AndroidSystemServices(this.getEnvironment()).getServiceConstantRef(serviceType);
        if ("android.appwidget.AppWidgetManager".equals(fieldTypeQualifiedName)) {
            targetBlock.add((IJStatement)fieldRef.assign(this.createSpecialInjection(holder, fieldTypeQualifiedName, serviceRef, 21, "LOLLIPOP", this.getClasses().APP_WIDGET_MANAGER, "getInstance", true)));
        } else {
            targetBlock.add((IJStatement)fieldRef.assign(this.createNormalInjection(holder, fieldTypeQualifiedName, serviceRef)));
        }
    }

    private IJExpression createSpecialInjection(EComponentHolder holder, String fieldTypeQualifiedName, JFieldRef serviceRef, int apiLevel, String apiLevelName, AbstractJClass serviceClass, String injectionMethodName, boolean invocationRequiresContext) {
        if (this.getEnvironment().getAndroidManifest().getMinSdkVersion() >= apiLevel) {
            return this.createNormalInjection(holder, fieldTypeQualifiedName, serviceRef);
        }
        JInvocation serviceClassInvocation = serviceClass.staticInvoke(injectionMethodName);
        if (invocationRequiresContext) {
            serviceClassInvocation.arg(holder.getContextRef());
        }
        if (this.isApiOnClasspath(apiLevelName)) {
            IJExpression condition = this.getClasses().BUILD_VERSION.staticRef("SDK_INT").gte((IJExpression)this.getClasses().BUILD_VERSION_CODES.staticRef(apiLevelName));
            IJExpression normalInjection = this.createNormalInjection(holder, fieldTypeQualifiedName, serviceRef);
            return JOp.cond((IJExpression)condition, (IJExpression)normalInjection, (IJExpression)serviceClassInvocation);
        }
        return serviceClassInvocation;
    }

    private IJExpression createNormalInjection(EComponentHolder holder, String fieldTypeQualifiedName, JFieldRef serviceRef) {
        return JExpr.cast((AbstractJType)this.getJClass(fieldTypeQualifiedName), (IJExpression)this.getAppropriateContextRef(holder, fieldTypeQualifiedName).invoke("getSystemService").arg((IJExpression)serviceRef));
    }

    private IJExpression getAppropriateContextRef(EComponentHolder holder, String fieldTypeQualifiedName) {
        if ("android.net.wifi.WifiManager".equals(fieldTypeQualifiedName) || "android.media.AudioManager".equals(fieldTypeQualifiedName)) {
            return holder.getContextRef().invoke("getApplicationContext");
        }
        return holder.getContextRef();
    }

    private boolean isApiOnClasspath(String apiName) {
        TypeElement typeElement = this.getProcessingEnvironment().getElementUtils().getTypeElement("android.os.Build.VERSION_CODES");
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getSimpleName().contentEquals(apiName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, valid);
    }
}

