/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JMethod;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.annotations.SupposeUiThread;
import org.androidannotations.api.BackgroundExecutor;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.internal.core.handler.SupposeThreadHandler;

public class SupposeUiThreadHandler
extends SupposeThreadHandler {
    private static final String METHOD_CHECK_UI_THREAD = "checkUiThread";

    public SupposeUiThreadHandler(AndroidAnnotationsEnvironment environment) {
        super(SupposeUiThread.class, environment);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod delegatingMethod = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        JBlock body = delegatingMethod.body();
        AbstractJClass bgExecutor = this.getJClass(BackgroundExecutor.class);
        body.pos(0);
        body.staticInvoke(bgExecutor, METHOD_CHECK_UI_THREAD);
        body.pos(body.getContents().size());
    }
}

