/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.annotations.SupposeBackground;
import org.androidannotations.api.BackgroundExecutor;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.internal.core.handler.SupposeThreadHandler;

public class SupposeBackgroundHandler
extends SupposeThreadHandler {
    private static final String METHOD_CHECK_BG_THREAD = "checkBgThread";

    public SupposeBackgroundHandler(AndroidAnnotationsEnvironment environment) {
        super(SupposeBackground.class, environment);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod delegatingMethod = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        AbstractJClass bgExecutor = this.getJClass(BackgroundExecutor.class);
        SupposeBackground annotation = element.getAnnotation(SupposeBackground.class);
        String[] serial = annotation.serial();
        JInvocation invocation = bgExecutor.staticInvoke(METHOD_CHECK_BG_THREAD);
        for (String s : serial) {
            invocation.arg((IJExpression)JExpr.lit((String)s));
        }
        JBlock body = delegatingMethod.body();
        body.pos(0);
        body.add((IJStatement)invocation);
        body.pos(body.getContents().size());
    }
}

