/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JStringLiteral;
import com.helger.jcodemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.sharedpreferences.DefaultBoolean;
import org.androidannotations.annotations.sharedpreferences.DefaultFloat;
import org.androidannotations.annotations.sharedpreferences.DefaultInt;
import org.androidannotations.annotations.sharedpreferences.DefaultLong;
import org.androidannotations.annotations.sharedpreferences.DefaultRes;
import org.androidannotations.annotations.sharedpreferences.DefaultString;
import org.androidannotations.annotations.sharedpreferences.DefaultStringSet;
import org.androidannotations.annotations.sharedpreferences.SharedPref;
import org.androidannotations.api.sharedpreferences.AbstractPrefField;
import org.androidannotations.api.sharedpreferences.BooleanPrefField;
import org.androidannotations.api.sharedpreferences.FloatPrefField;
import org.androidannotations.api.sharedpreferences.IntPrefField;
import org.androidannotations.api.sharedpreferences.LongPrefField;
import org.androidannotations.api.sharedpreferences.StringPrefField;
import org.androidannotations.api.sharedpreferences.StringSetPrefField;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.SharedPrefHolder;
import org.androidannotations.internal.core.handler.CoreBaseGeneratingAnnotationHandler;
import org.androidannotations.rclass.IRClass;
import org.androidannotations.rclass.IRInnerClass;

public class SharedPrefHandler
extends CoreBaseGeneratingAnnotationHandler<SharedPrefHolder> {
    private static final Map<String, DefaultPrefInfo<?>> DEFAULT_PREF_INFOS = new HashMap<String, DefaultPrefInfo<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("boolean", new DefaultPrefInfo<Boolean>(DefaultBoolean.class, BooleanPrefField.class, IRClass.Res.BOOL, false, "booleanField"));
            this.put("float", new DefaultPrefInfo<Float>(DefaultFloat.class, FloatPrefField.class, IRClass.Res.INTEGER, Float.valueOf(0.0f), "floatField"));
            this.put("int", new DefaultPrefInfo<Integer>(DefaultInt.class, IntPrefField.class, IRClass.Res.INTEGER, 0, "intField"));
            this.put("long", new DefaultPrefInfo<Long>(DefaultLong.class, LongPrefField.class, IRClass.Res.INTEGER, 0L, "longField"));
            this.put(CanonicalNameConstants.STRING, new DefaultPrefInfo<String>(DefaultString.class, StringPrefField.class, IRClass.Res.STRING, "", "stringField"));
            this.put("java.util.Set<java.lang.String>", new DefaultPrefInfo<Object>(DefaultStringSet.class, StringSetPrefField.class, IRClass.Res.ARRAY, null, "stringSetField"));
        }
    };

    public SharedPrefHandler(AndroidAnnotationsEnvironment environment) {
        super(SharedPref.class, environment);
    }

    @Override
    public SharedPrefHolder createGeneratedClassHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedElement) throws Exception {
        return new SharedPrefHolder(environment, annotatedElement);
    }

    @Override
    public void validate(Element element, ElementValidation validation) {
        super.validate(element, validation);
        TypeElement typeElement = (TypeElement)element;
        this.validatorHelper.isInterface(typeElement, validation);
        List<? extends Element> inheritedMembers = this.getProcessingEnvironment().getElementUtils().getAllMembers(typeElement);
        for (Element element2 : inheritedMembers) {
            if (element2.getEnclosingElement().asType().toString().equals("java.lang.Object")) continue;
            this.coreValidatorHelper.isPrefMethod(element2, validation);
            IdValidatorHelper defaultAnnotationValidatorHelper = null;
            if (!validation.isValid()) continue;
            DefaultPrefInfo<?> info = DEFAULT_PREF_INFOS.get(((ExecutableElement)element2).getReturnType().toString());
            this.coreValidatorHelper.hasCorrectDefaultAnnotation((ExecutableElement)element2, validation);
            if (validation.isValid() && element2.getAnnotation(DefaultRes.class) != null) {
                defaultAnnotationValidatorHelper = new IdValidatorHelper(new IdAnnotationHelper(this.getEnvironment(), DefaultRes.class.getName()));
                defaultAnnotationValidatorHelper.resIdsExist(element2, info.resType, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, validation);
            } else if (validation.isValid() && element2.getAnnotation(info.annotationClass) != null) {
                defaultAnnotationValidatorHelper = new IdValidatorHelper(new IdAnnotationHelper(this.getEnvironment(), info.annotationClass.getName()));
            }
            if (!validation.isValid() || defaultAnnotationValidatorHelper == null) continue;
            defaultAnnotationValidatorHelper.annotationParameterIsOptionalValidResId(element2, IRClass.Res.STRING, "keyRes", validation);
        }
        SharedPref sharedPrefAnnotation = element.getAnnotation(SharedPref.class);
        SharedPref.Scope scope = sharedPrefAnnotation.value();
        String name = sharedPrefAnnotation.name();
        boolean hasCustomName = !name.trim().isEmpty();
        EnumSet<SharedPref.Scope> allowedScopes = EnumSet.of(SharedPref.Scope.ACTIVITY, SharedPref.Scope.UNIQUE);
        if (hasCustomName && !allowedScopes.contains(scope)) {
            validation.addError("SharedPref#name() is only supported for Scope.ACTIVITY and Scope.UNIQUE.");
        }
    }

    @Override
    public void process(Element element, SharedPrefHolder holder) {
        this.generateConstructor(element, holder);
        this.generateFieldMethodAndEditorFieldMethod(element, holder);
    }

    private void generateConstructor(Element element, SharedPrefHolder holder) {
        SharedPref sharedPrefAnnotation = element.getAnnotation(SharedPref.class);
        SharedPref.Scope scope = sharedPrefAnnotation.value();
        String name = sharedPrefAnnotation.name();
        int mode = sharedPrefAnnotation.mode();
        if (name.trim().isEmpty()) {
            name = element.getSimpleName().toString();
        }
        JBlock constructorSuperBlock = holder.getConstructorSuperBlock();
        JVar contextParam = holder.getConstructorContextParam();
        switch (scope) {
            case ACTIVITY_DEFAULT: {
                JMethod getLocalClassName = this.getLocalClassName(holder);
                constructorSuperBlock.invoke("super").arg((IJExpression)contextParam.invoke("getSharedPreferences").arg((IJExpression)JExpr.invoke((JMethod)getLocalClassName).arg((IJExpression)contextParam)).arg((IJExpression)JExpr.lit((int)mode)));
                break;
            }
            case ACTIVITY: {
                JMethod getLocalClassName = this.getLocalClassName(holder);
                constructorSuperBlock.invoke("super").arg((IJExpression)contextParam.invoke("getSharedPreferences").arg(JExpr.invoke((JMethod)getLocalClassName).arg((IJExpression)contextParam).plus((IJExpression)JExpr.lit((String)("_" + name)))).arg((IJExpression)JExpr.lit((int)mode)));
                break;
            }
            case UNIQUE: {
                constructorSuperBlock.invoke("super").arg((IJExpression)contextParam.invoke("getSharedPreferences").arg((IJExpression)JExpr.lit((String)name)).arg((IJExpression)JExpr.lit((int)mode)));
                break;
            }
            case APPLICATION_DEFAULT: {
                AbstractJClass preferenceManagerClass = this.getJClass("android.preference.PreferenceManager");
                constructorSuperBlock.invoke("super").arg((IJExpression)preferenceManagerClass.staticInvoke("getDefaultSharedPreferences").arg((IJExpression)contextParam));
                break;
            }
        }
    }

    private JMethod getLocalClassName(SharedPrefHolder holder) {
        AbstractJClass stringClass = this.getClasses().STRING;
        JMethod getLocalClassName = holder.getGeneratedClass().method(20, (AbstractJType)stringClass, "getLocalClassName");
        AbstractJClass contextClass = this.getClasses().CONTEXT;
        JVar contextParam = getLocalClassName.param((AbstractJType)contextClass, "context");
        JBlock body = getLocalClassName.body();
        JVar packageName = body.decl((AbstractJType)stringClass, "packageName", (IJExpression)contextParam.invoke("getPackageName"));
        JVar className = body.decl((AbstractJType)stringClass, "className", (IJExpression)contextParam.invoke("getClass").invoke("getName"));
        JVar packageLen = body.decl((AbstractJType)this.getCodeModel().INT, "packageLen", (IJExpression)packageName.invoke("length"));
        IJExpression condition = className.invoke("startsWith").arg((IJExpression)packageName).not().cor(className.invoke("length").lte((IJExpression)packageLen)).cor(className.invoke("charAt").arg((IJExpression)packageLen).ne((IJExpression)JExpr.lit((char)'.')));
        body._if(condition)._then()._return((IJExpression)className);
        body._return((IJExpression)className.invoke("substring").arg(packageLen.plus((IJExpression)JExpr.lit((int)1))));
        return getLocalClassName;
    }

    private void generateFieldMethodAndEditorFieldMethod(Element element, SharedPrefHolder sharedPrefHolder) {
        for (ExecutableElement method : this.getValidMethods(element)) {
            IJExpression keyExpression = this.generateFieldMethod(sharedPrefHolder, method);
            sharedPrefHolder.createEditorFieldMethods(method, keyExpression);
        }
    }

    private List<ExecutableElement> getValidMethods(Element element) {
        List<? extends Element> members = element.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(members);
        ArrayList<ExecutableElement> validMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            validMethods.add(method);
        }
        return validMethods;
    }

    private IJExpression generateFieldMethod(SharedPrefHolder holder, ExecutableElement method) {
        DefaultPrefInfo<?> info = DEFAULT_PREF_INFOS.get(method.getReturnType().toString());
        return this.createFieldMethod(holder, method, info.annotationClass, info.prefFieldClass, info.defaultValue, info.resType, info.fieldHelperMethodName);
    }

    private IJExpression createFieldMethod(SharedPrefHolder holder, ExecutableElement method, Class<? extends Annotation> annotationClass, Class<? extends AbstractPrefField<?>> prefFieldClass, Object defaultValue, IRClass.Res resType, String fieldHelperMethodName) {
        String defaultValueStr;
        JStringLiteral keyExpression;
        IJExpression defaultValueExpr;
        Annotation annotation = method.getAnnotation(annotationClass);
        HashSet<String> value = null;
        if (annotation != null) {
            value = (HashSet<String>)this.annotationHelper.extractAnnotationParameter(method, annotationClass.getName(), "value");
        }
        if (annotation != null && method.getAnnotation(DefaultStringSet.class) == null) {
            defaultValueExpr = this.codeModelHelper.litObject(value);
        } else if (method.getAnnotation(DefaultRes.class) != null) {
            defaultValueExpr = this.extractResValue(holder, method, resType);
            annotationClass = DefaultRes.class;
        } else if (method.getAnnotation(DefaultStringSet.class) != null) {
            if (value != null) {
                HashSet<String> arrayValues;
                value = arrayValues = new HashSet<String>(Arrays.asList((String[])value));
                if (arrayValues.isEmpty()) {
                    defaultValueExpr = this.newEmptyStringHashSet();
                } else {
                    JInvocation arrayAsList = this.getClasses().ARRAYS.staticInvoke("asList");
                    for (String arrayValue : arrayValues) {
                        arrayAsList.arg((IJExpression)JExpr.lit((String)arrayValue));
                    }
                    defaultValueExpr = JExpr._new((AbstractJClass)this.getClasses().HASH_SET.narrow(this.getClasses().STRING)).arg((IJExpression)arrayAsList);
                }
            } else {
                defaultValueExpr = this.newEmptyStringHashSet();
            }
            annotationClass = DefaultStringSet.class;
        } else {
            defaultValueExpr = defaultValue != null ? this.codeModelHelper.litObject(defaultValue) : this.newEmptyStringHashSet();
            annotationClass = null;
        }
        Integer keyResId = -1;
        if (annotationClass != null) {
            keyResId = (Integer)this.annotationHelper.extractAnnotationParameter(method, annotationClass.getName(), "keyRes");
        }
        String fieldName = method.getSimpleName().toString();
        if (keyResId == -1) {
            keyExpression = JExpr.lit((String)fieldName);
        } else {
            IRInnerClass idClass = this.getEnvironment().getRClass().get(IRClass.Res.STRING);
            JFieldRef idRef = idClass.getIdStaticRef(keyResId, this.getEnvironment());
            keyExpression = holder.getEditorContextField().invoke("getString").arg((IJExpression)idRef);
        }
        String docComment = this.getProcessingEnvironment().getElementUtils().getDocComment(method);
        String string = defaultValueStr = value == null ? null : ((Object)value).toString();
        if (defaultValueStr == null) {
            defaultValueStr = defaultValue == null ? null : defaultValue.toString();
        }
        holder.createFieldMethod(prefFieldClass, (IJExpression)keyExpression, fieldName, fieldHelperMethodName, defaultValueExpr, docComment, defaultValueStr);
        return keyExpression;
    }

    private IJExpression extractResValue(SharedPrefHolder holder, Element method, IRClass.Res res) {
        JFieldRef idRef = this.annotationHelper.extractOneAnnotationFieldRef(method, DefaultRes.class.getCanonicalName(), res, true);
        String resourceGetMethodName = null;
        switch (res) {
            case BOOL: {
                resourceGetMethodName = "getBoolean";
                break;
            }
            case INTEGER: {
                resourceGetMethodName = "getInteger";
                break;
            }
            case STRING: {
                resourceGetMethodName = "getString";
                break;
            }
            case ARRAY: {
                resourceGetMethodName = "getStringArray";
                break;
            }
        }
        JInvocation resourceInvocation = holder.getContextField().invoke("getResources").invoke(resourceGetMethodName).arg((IJExpression)idRef);
        if (IRClass.Res.ARRAY.equals((Object)res)) {
            JInvocation asList = this.getClasses().ARRAYS.staticInvoke("asList");
            JInvocation newHashMap = JExpr._new((AbstractJClass)this.getClasses().HASH_SET.narrow(this.getClasses().STRING));
            resourceInvocation = newHashMap.arg((IJExpression)asList.arg((IJExpression)resourceInvocation));
        }
        return resourceInvocation;
    }

    private IJExpression newEmptyStringHashSet() {
        return JExpr._new((AbstractJClass)this.getClasses().HASH_SET.narrow(this.getClasses().STRING)).arg((IJExpression)JExpr.lit((int)0));
    }

    private static final class DefaultPrefInfo<T> {
        final Class<? extends Annotation> annotationClass;
        final Class<? extends AbstractPrefField<?>> prefFieldClass;
        final IRClass.Res resType;
        final T defaultValue;
        final String fieldHelperMethodName;

        DefaultPrefInfo(Class<? extends Annotation> annotationClass, Class<? extends AbstractPrefField<?>> prefFieldClass, IRClass.Res resType, T defaultValue, String fieldHelperMethodName) {
            this.annotationClass = annotationClass;
            this.prefFieldClass = prefFieldClass;
            this.resType = resType;
            this.defaultValue = defaultValue;
            this.fieldHelperMethodName = fieldHelperMethodName;
        }
    }
}

