/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal.core.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.ServiceAction;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.holder.EIntentServiceHolder;

public class ServiceActionHandler
extends BaseAnnotationHandler<EIntentServiceHolder> {
    public ServiceActionHandler(AndroidAnnotationsEnvironment environment) {
        super(ServiceAction.class, environment);
    }

    @Override
    protected void validate(Element element, ElementValidation validation) {
        this.validatorHelper.enclosingElementHasEIntentService(element, validation);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, validation);
        this.validatorHelper.isNotPrivate(element, validation);
    }

    @Override
    public void process(Element element, EIntentServiceHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        String methodName = element.getSimpleName().toString();
        ServiceAction annotation = element.getAnnotation(ServiceAction.class);
        String extraKey = annotation.value();
        if (extraKey.isEmpty()) {
            extraKey = methodName;
        }
        JFieldVar actionKeyField = this.createStaticActionField(holder, extraKey, methodName);
        this.addActionInOnHandleIntent(holder, executableElement, methodName, actionKeyField);
        this.addActionToIntentBuilder(holder, executableElement, methodName, actionKeyField);
    }

    private JFieldVar createStaticActionField(EIntentServiceHolder holder, String extraKey, String methodName) {
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase("action", methodName, null);
        return holder.getGeneratedClass().field(25, (AbstractJType)this.getClasses().STRING, staticFieldName, (IJExpression)JExpr.lit((String)extraKey));
    }

    private void addActionInOnHandleIntent(EIntentServiceHolder holder, ExecutableElement executableElement, String methodName, JFieldVar actionKeyField) {
        JMethod onHandleIntentMethod = holder.getOnHandleIntentMethod();
        JInvocation actionCondition = actionKeyField.invoke("equals").arg((IJExpression)holder.getOnHandleIntentIntentAction());
        JBlock callActionBlock = holder.getOnHandleIntentBody()._if((IJExpression)actionCondition)._then();
        JInvocation callActionInvocation = JExpr._super().invoke(methodName);
        List<? extends VariableElement> methodParameters = executableElement.getParameters();
        if (methodParameters.size() > 0) {
            JVar intent = holder.getOnHandleIntentIntent();
            JVar extras = callActionBlock.decl((AbstractJType)this.getClasses().BUNDLE, "extras");
            extras.init((IJExpression)intent.invoke("getExtras"));
            callActionBlock = callActionBlock._if(extras.ne((IJExpression)JExpr._null()))._then();
            for (VariableElement variableElement : methodParameters) {
                String paramName = variableElement.getSimpleName().toString();
                String extraParamName = paramName + "Extra";
                JFieldVar paramVar = this.getStaticExtraField(holder, paramName);
                AbstractJClass extraParamClass = this.codeModelHelper.typeMirrorToJClass(variableElement.asType());
                BundleHelper bundleHelper = new BundleHelper(this.getEnvironment(), variableElement.asType());
                IJExpression getExtraExpression = bundleHelper.getExpressionToRestoreFromBundle(extraParamClass, (IJExpression)extras, (IJExpression)paramVar, onHandleIntentMethod);
                JVar extraField = callActionBlock.decl((AbstractJType)extraParamClass, extraParamName, getExtraExpression);
                callActionInvocation.arg((IJExpression)extraField);
            }
        }
        callActionBlock.add((IJStatement)callActionInvocation);
        callActionBlock._return();
    }

    private void addActionToIntentBuilder(EIntentServiceHolder holder, ExecutableElement executableElement, String methodName, JFieldVar actionKeyField) {
        JMethod method = holder.getIntentBuilderClass().method(1, (AbstractJType)holder.getIntentBuilderClass(), methodName);
        JBlock body = method.body();
        String docComment = this.getProcessingEnvironment().getElementUtils().getDocComment(executableElement);
        this.codeModelHelper.addTrimmedDocComment(method, docComment);
        method.javadoc().addReturn().append((Object)"the IntentBuilder to chain calls");
        body.invoke("action").arg((IJExpression)actionKeyField);
        for (VariableElement variableElement : executableElement.getParameters()) {
            String paramName = variableElement.getSimpleName().toString();
            AbstractJClass parameterClass = this.codeModelHelper.typeMirrorToJClass(variableElement.asType());
            JFieldVar paramVar = this.getStaticExtraField(holder, paramName);
            JVar methodParam = method.param((AbstractJType)parameterClass, paramName);
            JInvocation putExtraInvocation = holder.getIntentBuilder().getSuperPutExtraInvocation(variableElement.asType(), methodParam, paramVar);
            body.add((IJStatement)putExtraInvocation);
        }
        body._return((IJExpression)JExpr._this());
    }

    private JFieldVar getStaticExtraField(EIntentServiceHolder holder, String extraName) {
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase(null, extraName, "Extra");
        JFieldVar staticExtraField = (JFieldVar)holder.getGeneratedClass().fields().get(staticFieldName);
        if (staticExtraField == null) {
            staticExtraField = holder.getGeneratedClass().field(25, (AbstractJType)this.getClasses().STRING, staticFieldName, (IJExpression)JExpr.lit((String)extraName));
        }
        return staticExtraField;
    }
}

